/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.common.QuestLocationChangeMode;
import com.equestricraft.common.Range;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.npc.NPCFollowPlayerSetEvent;
import com.equestricraft.core.npc.NPCFollowPlayerStopEvent;
import com.equestricraft.core.quest.element.QuestLocationChangeObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.awt.Rectangle;

public class QuestLocationChangeObjectiveLifecycle
extends QuestObjectiveElementLifecycle<QuestLocationChangeObjective> {
    public QuestLocationChangeObjectiveLifecycle(QuestLocationChangeObjective element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onObjectiveActivate() {
        if (((QuestLocationChangeObjective)this.element).getFollowingNpc() != null) {
            NPCFollowPlayerSetEvent event = new NPCFollowPlayerSetEvent(((QuestLocationChangeObjective)this.element).getFollowingNpc(), this.player, ((QuestLocationChangeObjective)this.element).getFollowingNpcSpeed());
            ECEventBus.post(event);
        }
        this.updateCompass();
    }

    @Override
    void onResume() {
        this.updateCompass();
    }

    private void updateCompass() {
        if (((QuestLocationChangeObjective)this.element).isShowOnCompass()) {
            if (((QuestLocationChangeObjective)this.element).getLocationChangeMode() == QuestLocationChangeMode.ENTER_LOCATION) {
                Coordinate coordinate = this.getCoordinate();
                this.player.getCompassManager().addCoordinates(((QuestLocationChangeObjective)this.element).getId(), coordinate);
            } else {
                this.player.getCompassManager().addCoordinates(((QuestLocationChangeObjective)this.element).getId(), this.getCoordinate(), true);
            }
        }
    }

    private Coordinate getCoordinate() {
        Rectangle bounds = ((QuestLocationChangeObjective)this.element).getLocationChangeArea().getArea().getBounds();
        Range<Integer> yRange = ((QuestLocationChangeObjective)this.element).getLocationChangeArea().getRangeY();
        double centerX = bounds.getCenterX();
        int centerY = (yRange.getLowerBound() + yRange.getUpperBound()) / 2;
        double centerZ = bounds.getCenterY();
        return new Coordinate(centerX, centerY, centerZ, ((QuestLocationChangeObjective)this.element).getLocationChangeArea().getDimension().getIdentifier());
    }

    public void advance() {
        if (((QuestLocationChangeObjective)this.element).getFollowingNpc() != null) {
            NPCFollowPlayerStopEvent event = new NPCFollowPlayerStopEvent(((QuestLocationChangeObjective)this.element).getFollowingNpc(), this.player);
            ECEventBus.post(event);
        }
        this.activateSuccessOutput();
    }

    @Override
    void onDeactivate() {
        this.player.getCompassManager().removeCoordinates(((QuestLocationChangeObjective)this.element).getId());
    }
}

