/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.placeholder.QuestPlaceholderSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;

public abstract class QuestObjectiveElementLifecycle<O extends QuestObjective>
extends QuestElementLifecycle<O> {
    @Service
    private static QuestPlaceholderSession questPlaceholderSession;

    QuestObjectiveElementLifecycle(O element, QuestPlayer player) {
        super(element, player);
    }

    public String getHint() {
        return ((QuestObjective)this.element).getHint();
    }

    @Override
    final void onActivate() {
        if (((QuestObjective)this.element).getStartMessage() != null && !((QuestObjective)this.element).getStartMessage().isBlank()) {
            String message = questPlaceholderSession.translatePlaceholders(((QuestObjective)this.element).getStartMessage(), this.player, ((QuestObjective)this.element).getQuest());
            message = new QuestStringInterpolator(this.player, this).execute(message);
            this.player.sendMessage(message);
        }
        if (((QuestObjective)this.element).isShowTitle()) {
            String title = new QuestStringInterpolator(this.player, this).execute(this.getName());
            this.player.sendTitle(title, "");
        }
        this.onObjectiveActivate();
    }

    void onObjectiveActivate() {
    }
}

