/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.quest.OutputIdentifierFunction;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.element.QuestScriptElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.ArrayList;

public class QuestScriptElementLifecycle
extends QuestElementLifecycle<QuestScriptElement> {
    @Service
    private static QuestScriptSession questScriptSession;
    private static final Log log;

    public QuestScriptElementLifecycle(QuestScriptElement element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onActivate() {
        GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(((QuestScriptElement)this.element).getScriptText());
        questScriptSession.initCoreVariables(executor, this.player);
        executor.withBlankVariable("outputIdentifier");
        OutputIdentifierFunction outputIdentifierFunction = new OutputIdentifierFunction();
        executor.withVariable("output", outputIdentifierFunction);
        try {
            ArrayList<String> outputs = new ArrayList<String>();
            GroovyScriptResponse response = executor.execute();
            String output = response.getStringVariable("outputIdentifier");
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
            if (output != null) {
                outputs.add(output);
            }
            if (outputIdentifierFunction.isSuccess()) {
                this.activateSuccessOutput();
            }
            if (outputIdentifierFunction.isFailure()) {
                this.activateFailureOutput();
            }
            outputs.addAll(outputIdentifierFunction.pickRandoms());
            if (!outputs.isEmpty()) {
                outputs.forEach(this::activateElementOutput);
            } else if (!outputIdentifierFunction.isSuccess() && !((QuestScriptElement)this.element).getOutputs().isEmpty()) {
                this.activateSuccessOutput();
            }
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for element %s", ((QuestScriptElement)this.element).getNameKey()), ex);
            throw new QuestException(ex);
        }
    }

    static {
        log = Log.getLogger(QuestScriptElementLifecycle.class.getName());
    }
}

