/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.quest.CompassPointFunction;
import com.equestricraft.core.quest.OutputIdentifierFunction;
import com.equestricraft.core.quest.QuestCompassEntry;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.element.QuestScriptedObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class QuestScriptedObjectiveLifecycle
extends QuestObjectiveElementLifecycle<QuestScriptedObjective> {
    @Service
    private static QuestScriptSession questScriptSession;
    @Service
    private static QuestPlaySession questPlaySession;
    private Timer timer = null;
    private TimerTask timerTask = null;
    private final List<UUID> currentCoordinatesIds = new ArrayList<UUID>();
    private static final Log log;

    public QuestScriptedObjectiveLifecycle(QuestScriptedObjective element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onObjectiveActivate() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    QuestScriptedObjectiveLifecycle.this.executeScript();
                }
                catch (QuestException ex) {
                    questPlaySession.abortTrackedQuestWithError(QuestScriptedObjectiveLifecycle.this.player, ex.getMessage());
                }
            }
        };
        this.timer.schedule(this.timerTask, 0L, (long)((QuestScriptedObjective)this.element).getSecondsInterval().intValue() * 1000L);
    }

    private void executeScript() {
        GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(((QuestScriptedObjective)this.element).getScriptText());
        questScriptSession.initCoreVariables(executor, this.player);
        executor.withBlankVariable("outputIdentifier");
        OutputIdentifierFunction outputIdentifierFunction = new OutputIdentifierFunction();
        executor.withVariable("output", outputIdentifierFunction);
        CompassPointFunction compassPointFunction = new CompassPointFunction();
        executor.withVariable("compassPoint", compassPointFunction);
        try {
            GroovyScriptResponse response = executor.execute();
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
            ArrayList<String> outputs = new ArrayList<String>(0);
            String output = response.getStringVariable("outputIdentifier");
            if (output != null) {
                outputs.add(output);
            }
            if (outputIdentifierFunction.isSuccess()) {
                this.activateSuccessOutput();
            }
            if (outputIdentifierFunction.isFailure()) {
                this.activateFailureOutput();
            }
            outputs.addAll(outputIdentifierFunction.pickRandoms());
            if (!outputs.isEmpty()) {
                outputs.forEach(this::activateElementOutput);
            }
            if (((QuestScriptedObjective)this.element).isShowOnCompass()) {
                this.currentCoordinatesIds.forEach(this.player.getCompassManager()::removeCoordinates);
                this.currentCoordinatesIds.clear();
                for (QuestCompassEntry coordinate : compassPointFunction.getEntries()) {
                    this.player.getCompassManager().addCoordinates(coordinate);
                    this.currentCoordinatesIds.add(coordinate.uuid());
                }
            }
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for element %s", ((QuestScriptedObjective)this.element).getNameKey()), ex);
            throw new QuestException(ex);
        }
    }

    @Override
    void onDeactivate() {
        this.timerTask.cancel();
        this.currentCoordinatesIds.forEach(this.player.getCompassManager()::removeCoordinates);
        this.currentCoordinatesIds.clear();
    }

    @Override
    void reset() {
        this.timer = new Timer(ThreadUtils.threadName(((QuestScriptedObjective)this.element).getQuest().getId() + "_" + ((QuestScriptedObjective)this.element).getNameKey()));
        this.timerTask = null;
        this.currentCoordinatesIds.clear();
    }

    static {
        log = Log.getLogger(QuestScriptedObjectiveLifecycle.class.getName());
    }
}

