/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.element.QuestTimerElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class QuestTimerElementLifecycle
extends QuestElementLifecycle<QuestTimerElement> {
    private Timer timer = null;
    private TimerTask timerTask = null;
    private Date endTime = null;

    public QuestTimerElementLifecycle(QuestTimerElement element, QuestPlayer player) {
        super(element, player);
        this.reset();
    }

    @Override
    void onActivate() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    QuestTimerElementLifecycle.this.activateSuccessOutput();
                }
                catch (QuestException ex) {
                    QuestElementLifecycle.questPlaySession.abortTrackedQuestWithError(QuestTimerElementLifecycle.this.player, ex.getMessage());
                }
            }
        };
        this.endTime = DateUtils.futureMillisOffset(((QuestTimerElement)this.element).getTimerDuration());
        this.timer.schedule(this.timerTask, this.endTime);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    void onDeactivate() {
        this.timerTask.cancel();
    }

    @Override
    void reset() {
        this.timer = new Timer(ThreadUtils.threadName(((QuestTimerElement)this.element).getQuest().getId() + "_" + ((QuestTimerElement)this.element).getNameKey()));
        this.timerTask = null;
    }
}

