/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.core.quest.element.QuestWaitElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class QuestWaitElementLifecycle
extends QuestElementLifecycle<QuestWaitElement> {
    private final AtomicInteger activatedInputCount = new AtomicInteger(0);

    public QuestWaitElementLifecycle(QuestWaitElement element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onActivate() {
        int activeInputs = this.activatedInputCount.incrementAndGet();
        if (activeInputs >= ((QuestWaitElement)this.element).getInputsNeeded()) {
            this.activateSuccessOutput();
        }
    }

    @Override
    void onDeactivate() {
        this.activatedInputCount.set(0);
    }

    @Override
    public void onSerialize(DataOutputStream outputStream2) throws IOException {
        outputStream2.writeInt(this.activatedInputCount.get());
    }

    @Override
    public void onDeserialize(DataInputStream inputStream2) throws IOException {
        int count = inputStream2.readInt();
        this.activatedInputCount.set(count);
    }
}

