/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.objectivecheck;

import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.QuestLocationChangeMode;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.quest.element.QuestLocationChangeObjective;
import com.equestricraft.core.quest.element.objectivecheck.QuestObjectiveCheck;
import java.awt.geom.Point2D;

public class LocationChangeObjectiveCheck
extends QuestObjectiveCheck<QuestLocationChangeObjective> {
    private final Coordinate location;

    public LocationChangeObjectiveCheck(Coordinate location) {
        this.location = location;
    }

    @Override
    protected QuestElementType getQuestObjectiveType() {
        return QuestElementType.LOCATION_CHANGE;
    }

    @Override
    protected boolean checkQuestObjective(QuestLocationChangeObjective objective) {
        boolean isInLocation = this.isInLocation(objective);
        return switch (objective.getLocationChangeMode()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestLocationChangeMode.ENTER_LOCATION -> isInLocation;
            case QuestLocationChangeMode.LEAVE_LOCATION -> !isInLocation;
        };
    }

    private boolean isInLocation(QuestLocationChangeObjective objective) {
        if (!objective.getLocationChangeArea().getDimension().getIdentifier().equals(this.location.world())) {
            return false;
        }
        if (!objective.getLocationChangeArea().getRangeY().containsValueWithin((int)this.location.y())) {
            return false;
        }
        Point2D.Double point = new Point2D.Double(this.location.x(), this.location.z());
        return objective.getLocationChangeArea().getArea().contains(point);
    }
}

