/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.QuestLogResult;
import com.equestricraft.core.quest.log.QuestLog;
import java.util.List;
import java.util.UUID;

public class QuestLogDatabase
implements RepositoryDatasource<QuestLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_QUEST_ID = "QUEST_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_OUTPUT_ID = "OUTPUT_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_RESULT = "RESULT";
    private static final String COLUMN_PLAYED_DESCRIPTION_OVERRIDE = "PLAYED_DESCRIPTION_OVERRIDE";
    private static final String COLUMN_STORY_GROUP_HIGHLIGHT_OVERRIDE = "STORY_GROUP_HIGHLIGHT_OVERRIDE";
    private static final String COLUMN_RESET = "RESET";

    @Override
    public void create(QuestLog questLog) {
        Query.insertInto("QUEST_LOG").columns(QueryColumn.column(COLUMN_QUEST_ID, questLog.getQuestId()), QueryColumn.column(COLUMN_PLAYER_ID, questLog.getPlayerId()), QueryColumn.column(COLUMN_OUTPUT_ID, questLog.getOutputId()), QueryColumn.column(COLUMN_TIME_STAMP, questLog.getTimestamp()), QueryColumn.column(COLUMN_RESULT, questLog.getQuestLogResult().name()), QueryColumn.column(COLUMN_PLAYED_DESCRIPTION_OVERRIDE, questLog.getPlayedDescriptionOverride()), QueryColumn.column(COLUMN_STORY_GROUP_HIGHLIGHT_OVERRIDE, questLog.getStoryGroupHighlightOverride()), QueryColumn.column(COLUMN_RESET, questLog.isReset())).executeGetGeneratedKey(questLog::setId);
    }

    @Override
    public List<QuestLog> retrieveAll() {
        return Query.selectAllFrom("QUEST_LOG").getList(this::getQuestLogFromResultRow);
    }

    private QuestLog getQuestLogFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int questId = row.getInt(COLUMN_QUEST_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        UUID outputId = row.getUuid(COLUMN_OUTPUT_ID);
        long timestamp = row.getLong(COLUMN_TIME_STAMP);
        QuestLogResult questLogResult = row.getEnum(COLUMN_RESULT, QuestLogResult.class);
        String playedDescriptionOverride = row.getNullableString(COLUMN_PLAYED_DESCRIPTION_OVERRIDE);
        String storyGroupHighlightOverride = row.getNullableString(COLUMN_STORY_GROUP_HIGHLIGHT_OVERRIDE);
        boolean reset2 = row.getBoolean(COLUMN_RESET);
        return new QuestLog(id, questId, playerId, outputId, timestamp, questLogResult, playedDescriptionOverride, storyGroupHighlightOverride, reset2);
    }

    @Override
    public void update(QuestLog questLog) {
        Query.update("QUEST_LOG").set(QueryColumn.column(COLUMN_RESET, questLog.isReset())).where(QueryColumn.column(COLUMN_ID, questLog.getId())).execute();
    }
}

