/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestLogResult;
import com.equestricraft.core.quest.log.QuestLog;
import com.equestricraft.core.quest.log.QuestLogDatabase;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class QuestLogRepository
extends Repository<QuestLog, Integer> {
    @Service
    private QuestLogDatabase questLogDatabase;

    @Override
    protected RepositoryDatasource<QuestLog, Integer> getDatasource() {
        return this.questLogDatabase;
    }

    public Optional<QuestLog> findMostRecentCompletedLogForQuestAndPlayer(int questId, int playerId) {
        RepositorySearchQuery<QuestLog> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(QuestLog::isReset);
        searchQuery.filter(l -> l.getQuestId() == questId);
        searchQuery.filter(l -> l.getPlayerId() == playerId);
        searchQuery.filter(l -> l.getQuestLogResult() == QuestLogResult.COMPLETED);
        searchQuery.sort(Comparator.comparingLong(QuestLog::getTimestamp));
        return searchQuery.single();
    }

    public List<QuestLog> findAllNonResetByQuestAndPlayer(int questId, int playerId) {
        RepositorySearchQuery<QuestLog> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(QuestLog::isReset);
        searchQuery.filter(l -> l.getQuestId() == questId);
        searchQuery.filter(l -> l.getPlayerId() == playerId);
        return searchQuery.many();
    }

    public List<QuestLog> findOrderedQuestCompletedLogsForPlayer(int playerId) {
        RepositorySearchQuery<QuestLog> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(QuestLog::isReset);
        searchQuery.filter(q -> q.getPlayerId() == playerId);
        searchQuery.filter(q -> q.getQuestLogResult() == QuestLogResult.COMPLETED);
        searchQuery.sort(Comparator.comparingLong(QuestLog::getTimestamp));
        return searchQuery.many();
    }

    public Optional<QuestLog> findMostRecentNonResetLogByQuestAndPlayer(int questId, int playerId) {
        RepositorySearchQuery<QuestLog> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(QuestLog::isReset);
        searchQuery.filter(l -> l.getQuestId() == questId);
        searchQuery.filter(l -> l.getPlayerId() == playerId);
        searchQuery.sort(Comparator.comparingLong(QuestLog::getTimestamp));
        return searchQuery.single();
    }
}

