/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.log;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestLogResult;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.log.QuestLog;
import com.equestricraft.core.quest.log.QuestLogRepository;
import com.equestricraft.core.quest.log.QuestLogSession;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class QuestLogSessionImpl
implements QuestLogSession {
    @Service
    private QuestLogRepository questLogRepository;

    @Override
    public void logQuestCompleted(ECPlayer player, Quest quest, UUID outputId, String playedDescriptionOverride, String storyGroupHighlightOverride) {
        this.logQuestLog(player, quest, outputId, QuestLogResult.COMPLETED, playedDescriptionOverride, storyGroupHighlightOverride);
    }

    @Override
    public void logQuestFailed(ECPlayer player, Quest quest, UUID outputId, String playedDescriptionOverride, String storyGroupHighlightOverride) {
        this.logQuestLog(player, quest, outputId, QuestLogResult.FAILED, playedDescriptionOverride, storyGroupHighlightOverride);
    }

    private void logQuestLog(ECPlayer player, Quest quest, UUID outputId, QuestLogResult questLogResult, String playedDescriptionOverride, String storyGroupHighlightOverride) {
        QuestLog questLog = new QuestLog(0, quest.getId(), player.getId(), outputId, System.currentTimeMillis(), questLogResult, playedDescriptionOverride, storyGroupHighlightOverride, false);
        this.questLogRepository.add(questLog);
    }

    @Override
    public Optional<Long> findMostRecentTimeForQuest(List<QuestLog> questLogs, int questId) {
        return questLogs.stream().filter(l -> l.getQuestId() == questId).findAny().map(QuestLog::getTimestamp);
    }

    @Override
    public Optional<Long> findMostRecentTimeForQuestAndOutput(List<QuestLog> questLogs, int questId, UUID outputId) {
        return questLogs.stream().filter(l -> l.getQuestId() == questId).filter(l -> {
            if (outputId == null) {
                return true;
            }
            return Objects.equals(l.getOutputId(), outputId);
        }).findFirst().map(QuestLog::getTimestamp);
    }

    @Override
    public boolean hasPlayerCompletedQuest(ECPlayer player, int questId) {
        return this.questLogRepository.findMostRecentCompletedLogForQuestAndPlayer(questId, player.getId()).isPresent();
    }

    @Override
    public void resetQuestForPlayer(ECPlayer player, Quest quest) {
        List<QuestLog> logs = this.questLogRepository.findAllNonResetByQuestAndPlayer(quest.getId(), player.getId());
        for (QuestLog log : logs) {
            log.setReset(true);
            log.save();
        }
    }
}

