/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.menu;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestType;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.QuestStartConditionSession;
import com.equestricraft.core.quest.QuestStartDetails;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.log.QuestLog;
import com.equestricraft.core.quest.log.QuestLogRepository;
import com.equestricraft.core.quest.log.QuestLogSession;
import com.equestricraft.core.quest.menu.QuestInProgressMenuItem;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestMenuSession;
import com.equestricraft.core.quest.menu.QuestSingleMenuItem;
import com.equestricraft.core.quest.menu.QuestStoryGroupMenuItem;
import com.equestricraft.core.quest.placeholder.QuestPlaceholderSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.requirementcheck.QuestRequirementCheckSession;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.core.quest.storygroup.QuestStoryGroup;
import com.equestricraft.core.quest.storygroup.QuestStoryGroupRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class QuestMenuSessionImpl
implements QuestMenuSession {
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestStoryGroupRepository questStoryGroupRepository;
    @Service
    private QuestLogRepository questLogRepository;
    @Service
    private QuestLogSession questLogSession;
    @Service
    private QuestStartConditionSession questStartConditionSession;
    @Service
    private QuestRequirementCheckSession questRequirementCheckSession;
    @Service
    private QuestPlaceholderSession questPlaceholderSession;

    @Override
    public List<QuestMenuItem> retrieveQuestMenuSections(QuestPlayer player, QuestType questType) {
        List<QuestStoryGroup> questStoryGroups = this.questStoryGroupRepository.findGroupsWithNoParents();
        List<QuestMenuItem> groupMenuItems = this.buildGroupMenuItems(questStoryGroups, player, questType);
        List<Quest> orphanQuests = this.questRepository.findActiveQuestsNotInAnyStoryGroupByType(questType);
        Stream<QuestStartDetails> orphanQuestStartElementPairs = orphanQuests.stream().map(q -> this.questStartConditionSession.findBlankStarterForQuest(player, (Quest)q));
        List<QuestMenuItem> orphanedQuestMenuItems = this.processStartDetailsToQuestItemList(orphanQuestStartElementPairs, player);
        ArrayList<QuestMenuItem> items = new ArrayList<QuestMenuItem>(groupMenuItems.size() + orphanedQuestMenuItems.size());
        items.addAll(groupMenuItems);
        items.addAll(orphanedQuestMenuItems);
        return items;
    }

    @Override
    public List<QuestMenuItem> retrieveQuestMenuSections(QuestPlayer player, QuestType questType, int storyGroupId) {
        List<QuestStoryGroup> childGroups = this.questStoryGroupRepository.findChildGroups(storyGroupId);
        if (childGroups.isEmpty()) {
            List<Quest> quests = this.questRepository.findActiveQuestsByStoryGroupAndType(storyGroupId, questType);
            Stream<QuestStartDetails> startElementPairs = quests.stream().map(q -> this.questStartConditionSession.findBlankStarterForQuest(player, (Quest)q));
            return this.processStartDetailsToQuestItemList(startElementPairs, player);
        }
        return this.buildGroupMenuItems(childGroups, player, questType);
    }

    private List<QuestMenuItem> buildGroupMenuItems(List<QuestStoryGroup> groups2, QuestPlayer player, QuestType questType) {
        return groups2.stream().filter(group -> this.canPlayerPlayAnyQuestInGroup((QuestStoryGroup)group, player, questType)).map(group -> this.buildMenuItem((QuestStoryGroup)group, player)).map(QuestMenuItem.class::cast).toList();
    }

    private QuestStoryGroupMenuItem buildMenuItem(QuestStoryGroup group, QuestPlayer player) {
        Double completionPercentage = this.calculateStoryGroupCompletionPercentageForPlayer(group, player);
        String description = this.buildStoryGroupDescriptionForPlayer(group, player);
        return new QuestStoryGroupMenuItem(group.getId(), group.getName(), description, completionPercentage);
    }

    private boolean canPlayerPlayAnyQuestInGroup(QuestStoryGroup group, ECPlayer player, QuestType questType) {
        List<QuestStoryGroup> childGroups = this.questStoryGroupRepository.findChildGroups(group.getId());
        if (childGroups.isEmpty()) {
            List<Quest> questsInGroup = this.questRepository.findActiveQuestsByStoryGroupAndType(group.getId(), questType);
            return questsInGroup.stream().map(q -> this.questStartConditionSession.findBlankStarterForQuest(player, (Quest)q)).anyMatch(q -> this.shouldShowOnMenu((QuestStartDetails)q, player));
        }
        return childGroups.stream().anyMatch(g -> this.canPlayerPlayAnyQuestInGroup((QuestStoryGroup)g, player, questType));
    }

    private String buildStoryGroupDescriptionForPlayer(QuestStoryGroup questStoryGroup, ECPlayer player) {
        Object description = questStoryGroup.getDescription();
        Optional<String> highlight = this.getStoryGroupHighlightToShow(questStoryGroup, player);
        if (highlight.isPresent()) {
            description = highlight.get() + "\n\n" + (String)description;
        }
        return description;
    }

    private Optional<String> getStoryGroupHighlightToShow(QuestStoryGroup questStoryGroup, ECPlayer player) {
        List<Quest> quests = this.questRepository.findActiveQuestsByStoryGroup(questStoryGroup.getId());
        List<QuestLog> playersLogs = this.questLogRepository.findOrderedQuestCompletedLogsForPlayer(player.getId());
        record QuestHighlightPair(Quest quest, String highlight) {
            boolean hasHighlight() {
                return this.highlight != null;
            }
        }
        record MostRecentItem(QuestHighlightPair highlightPair, Long time) {
            private final QuestHighlightPair highlightPair;

            MostRecentItem {
            }

            boolean hasBeenPlayed() {
                return this.time != null;
            }

            public QuestHighlightPair highlightPair() {
                return this.highlightPair;
            }
        }
        return quests.stream().map(q -> {
            String highlight = this.determineStoryGroupHighlight((Quest)q, player);
            return new QuestHighlightPair((Quest)q, highlight);
        }).filter(QuestHighlightPair::hasHighlight).map(p -> {
            Long mostRecentTime = this.questLogSession.findMostRecentTimeForQuest(playersLogs, p.quest().getId()).orElse(null);
            return new MostRecentItem((QuestHighlightPair)p, mostRecentTime);
        }).filter(MostRecentItem::hasBeenPlayed).max(Comparator.comparingLong(MostRecentItem::time)).map(MostRecentItem::highlightPair).map(QuestHighlightPair::highlight);
    }

    private String determineStoryGroupHighlight(Quest quest, ECPlayer player) {
        return this.questLogRepository.findMostRecentNonResetLogByQuestAndPlayer(quest.getId(), player.getId()).map(QuestLog::getStoryGroupHighlightOverride).orElseGet(quest::getStoryGroupHighlight);
    }

    private Double calculateStoryGroupCompletionPercentageForPlayer(QuestStoryGroup questStoryGroup, ECPlayer player) {
        List<QuestStoryGroup> childrenGroups = this.questStoryGroupRepository.findChildGroups(questStoryGroup.getId());
        if (!childrenGroups.isEmpty()) {
            return null;
        }
        List<Quest> questsInStoryGroup = this.questRepository.findActiveQuestsByStoryGroup(questStoryGroup.getId());
        List<Integer> questsInStoryGroupIds = questsInStoryGroup.stream().map(Quest::getId).toList();
        if (questsInStoryGroupIds.isEmpty()) {
            return null;
        }
        int totalActiveQuestsInStoryGroup = questsInStoryGroupIds.size();
        List<QuestLog> questLogs = this.questLogRepository.findOrderedQuestCompletedLogsForPlayer(player.getId());
        long completedCount = questLogs.stream().map(QuestLog::getQuestId).distinct().filter(questsInStoryGroupIds::contains).count();
        return (double)completedCount / (double)totalActiveQuestsInStoryGroup * 100.0;
    }

    @Override
    public List<QuestMenuItem> retrieveQuestMenuItemsForNpc(QuestPlayer player, NPC npc) {
        Stream<QuestStartDetails> quests = this.questStartConditionSession.findQuestsWithStartingNpc(player, npc);
        return this.processStartDetailsToQuestItemList(quests, player);
    }

    @Override
    public List<QuestMenuItem> retrieveQuestMenuItemsForBlockInteract(QuestPlayer player, BlockCoordinate blockCoordinate) {
        Stream<QuestStartDetails> quests = this.questStartConditionSession.findQuestsForBlockCoordinate(player, blockCoordinate);
        return this.processStartDetailsToQuestItemList(quests, player);
    }

    private List<QuestMenuItem> processStartDetailsToQuestItemList(Stream<QuestStartDetails> startDetails, QuestPlayer player) {
        List<QuestLog> playersQuestLogs = this.questLogRepository.findOrderedQuestCompletedLogsForPlayer(player.getId());
        return startDetails.filter(QuestStartDetails::showOnMenu).filter(q -> !player.isQuestInProgress(q.quest().getId())).filter(q -> this.shouldShowOnMenu((QuestStartDetails)q, player)).map(quest -> this.buildMenuItem((QuestStartDetails)quest, player, playersQuestLogs)).sorted(Comparator.comparing(QuestSingleMenuItem::isCompleted)).map(QuestMenuItem.class::cast).toList();
    }

    private QuestSingleMenuItem buildMenuItem(QuestStartDetails startDetails, QuestPlayer player, List<QuestLog> playersQuestLogs) {
        Quest quest = startDetails.quest();
        boolean completed = this.hasPlayerCompletedQuest(quest, playersQuestLogs);
        String description = completed ? this.determinePlayedDescription(quest, player) : quest.getNotYetPlayedDescription();
        description = this.questPlaceholderSession.translatePlaceholders(description, player, startDetails.quest());
        description = new QuestStringInterpolator(player).execute(description);
        double moneyReward = completed ? quest.getRewards().getReplayMoney() : quest.getRewards().getFirstMoney();
        int xpReward = completed ? quest.getRewards().getReplayXp() : quest.getRewards().getFirstXp();
        return new QuestSingleMenuItem(quest.getId(), quest.getName(), description, completed, !quest.isLive(), startDetails.startingElement() != null ? startDetails.startingElement().getId() : null, moneyReward > 0.0 ? EconomyUtilities.formatCurrency(moneyReward) : null, xpReward, startDetails.canPlayNow());
    }

    private boolean hasPlayerCompletedQuest(Quest quest, List<QuestLog> questLogs) {
        if (quest.isLive()) {
            Optional<Long> mostRecentPlay = this.questLogSession.findMostRecentTimeForQuest(questLogs, quest.getId());
            return mostRecentPlay.isPresent();
        }
        return false;
    }

    private String determinePlayedDescription(Quest quest, QuestPlayer player) {
        return this.questLogRepository.findMostRecentNonResetLogByQuestAndPlayer(quest.getId(), player.getId()).map(QuestLog::getPlayedDescriptionOverride).orElseGet(() -> {
            if (quest.getHasBeenPlayedDescription().isBlank()) {
                return quest.getNotYetPlayedDescription();
            }
            return quest.getHasBeenPlayedDescription();
        });
    }

    private boolean shouldShowOnMenu(QuestStartDetails startDetails, ECPlayer player) {
        if (startDetails.startingElement() == null) {
            return !startDetails.quest().isHiddenFromMenuWhenNotComplete();
        }
        return this.questRequirementCheckSession.canPlayerSeeOnQuestMenu(player, startDetails.startingElement());
    }

    @Override
    public List<QuestInProgressMenuItem> retrieveInProgressQuestMenuItemsForPlayer(QuestPlayer player) {
        Stream<Quest> inProgressQuests = this.getPlayersInProgressQuests(player);
        return inProgressQuests.map(q -> this.buildMenuItem((Quest)q, player)).toList();
    }

    private QuestInProgressMenuItem buildMenuItem(Quest q, QuestPlayer player) {
        PlayerQuestState state = player.getStateForQuest(q.getId());
        List<String> objectiveNames = state.getActiveObjectives().map(o -> o.getLifecycle(player)).map(l -> new QuestStringInterpolator(player, (QuestObjectiveElementLifecycle<?>)l).execute(l.getName())).toList();
        return new QuestInProgressMenuItem(q.getId(), q.getName(), objectiveNames);
    }

    private Stream<Quest> getPlayersInProgressQuests(QuestPlayer player) {
        PlayerQuestData data = player.getPlayerQuestData();
        return data.getAllInProgressQuestStates().stream().map(PlayerQuestState::getQuest);
    }
}

