/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.placeholder;

import com.equestricraft.api.common.APIActiveQuestDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestTransformer;
import com.equestricraft.core.quest.placeholder.QuestGlobalPlaceholderRepository;
import com.equestricraft.core.quest.placeholder.QuestPlaceholder;
import com.equestricraft.core.quest.placeholder.QuestPlaceholderSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class QuestPlaceholderSessionImpl
implements QuestPlaceholderSession {
    @Service
    private QuestGlobalPlaceholderRepository questGlobalPlaceholderRepository;
    @Service
    private QuestTransformer questTransformer;
    private static final String SPLIT_REGEX = "[^a-zA-Z0-9_%]+";
    private static final Log log = Log.getLogger(QuestPlaceholderSessionImpl.class.getName());

    @Override
    public String translatePlaceholders(String text, QuestPlayer player, Quest quest) {
        if (text.contains("%")) {
            text = this.translateGlobalPlaceholders(text, player);
            text = this.translateLocalPlaceholders(text, player, quest);
        }
        return text;
    }

    private String translateGlobalPlaceholders(String text, QuestPlayer player) {
        return this.translatePlaceholders(text, player, "%global_", this.questGlobalPlaceholderRepository::findGlobalPlaceholdersByIdentifiers);
    }

    private String translateLocalPlaceholders(String text, QuestPlayer player, Quest quest) {
        return this.translatePlaceholders(text, player, "%local_", quest::getLocalPlaceholders);
    }

    private String translatePlaceholders(String text, QuestPlayer player, String typePrefix, Function<List<String>, List<? extends QuestPlaceholder>> placeholdersFunction) {
        List<String> placeholderWords = this.extractUsedPlaceholders(text, typePrefix);
        if (ListUtils.isNotEmpty(placeholderWords)) {
            APIPlayerDtoImpl playerDto = new APIPlayerDtoImpl(player.getCorePlayer());
            List<? extends QuestPlaceholder> placeholders = placeholdersFunction.apply(placeholderWords);
            PlayerQuestState trackedQuestState = player.getTrackedQuestState();
            APIActiveQuestDto activeQuestDto = this.questTransformer.toDto(trackedQuestState);
            for (QuestPlaceholder questPlaceholder : placeholders) {
                try {
                    Object value;
                    GroovyStandardScriptExecutor executor = (GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(questPlaceholder.getScript()).withPlayer(playerDto)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl());
                    if (player.hasTrackedQuest()) {
                        executor.withVariable("quest", activeQuestDto);
                        executor.withSessionData(trackedQuestState.getGroovyScriptSessionData());
                    }
                    if ((value = executor.execute().result()) == null) continue;
                    text = text.replace(typePrefix + questPlaceholder.getIdentifier(), value.toString());
                }
                catch (GroovyException ex) {
                    log.error(String.format("Error running placeholder script for %s%s", typePrefix, questPlaceholder.getIdentifier()));
                    throw new QuestException(ex);
                }
            }
        }
        return text;
    }

    private List<String> extractUsedPlaceholders(String text, String placeholderTypePrefix) {
        if (text.contains(placeholderTypePrefix)) {
            return Arrays.stream(text.split(SPLIT_REGEX)).filter(w -> w.startsWith(placeholderTypePrefix)).map(w -> w.replace(placeholderTypePrefix, "")).toList();
        }
        return Collections.emptyList();
    }
}

