/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.progress;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.faction.PlayerFactionSession;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.log.QuestLogSession;
import com.equestricraft.core.quest.progress.QuestProgressResetSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestState;

@TransactionManagement
public class QuestProgressResetSessionImpl
implements QuestProgressResetSession {
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestLogSession questLogSession;
    @Service
    private QuestPlaySession questPlaySession;
    @Service
    private PlayerFactionSession playerFactionSession;

    @Override
    public void resetQuestProgressForPlayer(ECPlayer player) {
        this.abandonActiveQuests(player);
        this.resetQuestLogs(player);
        this.playerFactionSession.removePlayerFromFaction(player);
    }

    private void abandonActiveQuests(ECPlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        if (questPlayer.hasTrackedQuest()) {
            this.questPlaySession.abandonTrackedQuest(questPlayer);
        }
        for (PlayerQuestState quest : questPlayer.getPlayerQuestData().getAllInProgressQuestStates()) {
            this.questPlaySession.abandonQuest(questPlayer, quest.getQuest());
        }
    }

    private void resetQuestLogs(ECPlayer player) {
        this.questRepository.streamAll().filter(q -> q.getQuestType().isCanBeReset()).filter(q -> this.questLogSession.hasPlayerCompletedQuest(player, q.getId())).forEach(q -> this.questLogSession.resetQuestForPlayer(player, (Quest)q));
    }
}

