/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.questplayer;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestCompassManager;
import com.equestricraft.core.quest.QuestTrackStateUpdateEvent;
import com.equestricraft.core.quest.element.lifecycle.QuestLifecycleManager;
import com.equestricraft.core.quest.state.ActiveQuestStopwatch;
import com.equestricraft.core.quest.state.ActiveQuestTimer;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class QuestPlayer
implements ECPlayer {
    private final CorePlayer corePlayer;
    private PlayerQuestData playerQuestData = null;
    private final QuestLifecycleManager lifecycleManager = new QuestLifecycleManager(this);
    private final QuestCompassManager compassManager = new QuestCompassManager(this);

    public QuestPlayer(CorePlayer corePlayer) {
        this.corePlayer = corePlayer;
    }

    public void setPlayerQuestData(PlayerQuestData playerQuestData) {
        this.playerQuestData = playerQuestData;
    }

    @Override
    public CorePlayer getCorePlayer() {
        return this.corePlayer;
    }

    public PlayerQuestData getPlayerQuestData() {
        return this.playerQuestData;
    }

    public PlayerQuestState getTrackedQuestState() {
        PlayerQuestState data = this.getPlayerQuestData().getTrackedQuestState();
        return Objects.requireNonNull(data, "No tracked quest");
    }

    public Quest getTrackedQuest() {
        return this.getTrackedQuestState().getQuest();
    }

    public boolean hasTrackedQuest() {
        return this.getPlayerQuestData().hasTrackedQuest();
    }

    public Optional<ActiveQuestTimer> getActiveNonSilentTimer() {
        return this.getTrackedQuestState().getTimers().values().stream().filter(Predicate.not(ActiveQuestTimer::isSilent)).findFirst();
    }

    public Optional<ActiveQuestStopwatch> getActiveNonSilentStopwatch() {
        return this.getTrackedQuestState().getStopwatches().values().stream().filter(Predicate.not(ActiveQuestStopwatch::isSilent)).findFirst();
    }

    public PlayerQuestState getStateForQuest(int questId) {
        PlayerQuestState data = this.getPlayerQuestData().getStateForQuest(questId);
        return Objects.requireNonNull(data);
    }

    public boolean isQuestInProgress(int questId) {
        return this.getPlayerQuestData().isQuestInProgress(questId);
    }

    public boolean tryLock() {
        return this.playerQuestData.tryLock();
    }

    public void unlock() {
        this.playerQuestData.unlock();
    }

    public void fireUpdate() {
        QuestTrackStateUpdateEvent event = new QuestTrackStateUpdateEvent(this);
        ECEventBus.post(event);
    }

    public QuestLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public QuestCompassManager getCompassManager() {
        return this.compassManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ECPlayer)) {
            return false;
        }
        ECPlayer that = (ECPlayer)o;
        return Objects.equals(this.corePlayer, that.getCorePlayer());
    }

    public int hashCode() {
        return Objects.hash(this.corePlayer);
    }

    public String toString() {
        return this.corePlayer.toString();
    }
}

