/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.requirementcheck;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.requirementcheck.QuestRequirementCheckSession;
import com.equestricraft.core.quest.requirementcheck.check.QuestRequirementCheck;
import com.equestricraft.core.quest.requirementcheck.response.NotLiveQuestResponse;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class QuestRequirementCheckSessionImpl
implements QuestRequirementCheckSession {
    @Service
    private ServiceInstance<QuestRequirementCheck> questRequirementChecks;

    @Override
    public QuestRequirementCheckResponse doesPlayerMeetQuestRequirements(ECPlayer player, QuestStartElement startElement) {
        if (!startElement.getQuest().isLive()) {
            return new NotLiveQuestResponse(player);
        }
        AccumulatedResponse accumulated = new AccumulatedResponse();
        for (QuestRequirementCheck check2 : this.questRequirementChecks) {
            QuestRequirementCheckResponse response = check2.performCheck(player, startElement);
            accumulated.apply(response);
            if (!accumulated.isBlocksQuestCompletely()) continue;
            return accumulated;
        }
        return accumulated;
    }

    @Override
    public Boolean canPlayerPlayQuest(ECPlayer player, QuestStartElement startElement) {
        if (!startElement.getQuest().isLive()) {
            return player.hasPermission("equestricraft.quest.play-offline");
        }
        return this.questRequirementChecks.stream().noneMatch(Predicate.not(c -> c.canPlay(player, startElement)));
    }

    @Override
    public Boolean canPlayerSeeOnQuestMenu(ECPlayer player, QuestStartElement startElement) {
        if (!startElement.getQuest().isLive()) {
            return player.hasPermission("equestricraft.quest.play-offline");
        }
        return this.questRequirementChecks.stream().noneMatch(Predicate.not(c -> c.mayShowOnMenu(player, startElement)));
    }

    private static class AccumulatedResponse
    implements QuestRequirementCheckResponse {
        private boolean canPlay = true;
        private boolean mayShowOnMenu = true;
        private final List<String> messages = new ArrayList<String>(0);

        private AccumulatedResponse() {
        }

        public boolean isBlocksQuestCompletely() {
            return !this.canPlay() && !this.mayShowOnMenu();
        }

        public void apply(QuestRequirementCheckResponse response) {
            String message;
            if (!response.canPlay()) {
                this.canPlay = false;
            }
            if (!response.mayShowOnMenu()) {
                this.mayShowOnMenu = false;
            }
            if ((message = response.message()) != null) {
                this.messages.add(message);
            }
        }

        @Override
        public boolean canPlay() {
            return this.canPlay;
        }

        @Override
        public boolean mayShowOnMenu() {
            return this.mayShowOnMenu;
        }

        @Override
        public String message() {
            return String.join((CharSequence)", ", this.messages);
        }
    }
}

