/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.requirementcheck.check;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.log.QuestLog;
import com.equestricraft.core.quest.log.QuestLogRepository;
import com.equestricraft.core.quest.requirementcheck.check.QuestRequirementCheck;
import com.equestricraft.core.quest.requirementcheck.response.AlreadyPlayedQuest;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import java.util.Optional;

public class CanBeReplayedQuestPlayCheck
extends QuestRequirementCheck {
    @Service
    private QuestLogRepository questLogRepository;

    @Override
    public QuestRequirementCheckResponse performCheck(ECPlayer player, QuestStartElement startElement) {
        Optional<QuestLog> mostRecentPlay = this.questLogRepository.findMostRecentCompletedLogForQuestAndPlayer(startElement.getQuest().getId(), player.getId());
        if (mostRecentPlay.isPresent()) {
            if (startElement.isAllowMultiplePlay()) {
                int hoursSinceLastPlay = DateUtils.hoursSince(mostRecentPlay.get().getTimestamp());
                if (hoursSinceLastPlay < startElement.getPlayCoolDownHours()) {
                    return this.noAccess(I18n.getLabel("quest.played-too-recently"));
                }
            } else {
                return new AlreadyPlayedQuest();
            }
        }
        return this.fullAccess();
    }
}

