/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.requirementcheck.check;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.RequiredCharacter;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.requirementcheck.check.QuestRequirementCheck;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import java.time.Duration;
import java.util.Optional;

public class RequiredCharactersQuestPlayCheck
extends QuestRequirementCheck {
    @Override
    public QuestRequirementCheckResponse performCheck(ECPlayer player, QuestStartElement startElement) {
        for (RequiredCharacter requiredCharacter : startElement.getRequiredCharacters()) {
            boolean enoughDurationPassed;
            Optional<Duration> durationSinceFirstMet = player.getCharacters().getDurationSinceFirstMet(requiredCharacter.getCharacter());
            boolean bl = enoughDurationPassed = durationSinceFirstMet.isPresent() && durationSinceFirstMet.get().toHours() >= (long)requiredCharacter.getHoursWait();
            if (!enoughDurationPassed) {
                return this.noAccess(I18n.getLabel("quest.not-met-character", requiredCharacter.getCharacter().getName()));
            }
            Double friendshipWithCharacter = player.getCharacters().getFriendshipPercentage(requiredCharacter.getRequiredCharacterId()).orElse(0.0);
            if (requiredCharacter.getFriendshipPercentage().containsValueWithin(friendshipWithCharacter)) continue;
            return this.noAccess(I18n.getLabel("quest.friendship-range-invalid", requiredCharacter.getCharacter().getName()));
        }
        return this.fullAccess();
    }
}

