/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.requirementcheck.check;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.RequiredQuest;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.log.QuestLog;
import com.equestricraft.core.quest.log.QuestLogRepository;
import com.equestricraft.core.quest.log.QuestLogSession;
import com.equestricraft.core.quest.requirementcheck.check.QuestRequirementCheck;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import java.util.List;
import java.util.Optional;

public class RequiredQuestsQuestPlayCheck
extends QuestRequirementCheck {
    @Service
    private QuestLogRepository questLogRepository;
    @Service
    private QuestLogSession questLogSession;

    @Override
    public QuestRequirementCheckResponse performCheck(ECPlayer player, QuestStartElement startElement) {
        if (ListUtils.isNotEmpty(startElement.getRequiredQuests())) {
            List<QuestLog> questLogs = this.questLogRepository.findOrderedQuestCompletedLogsForPlayer(player.getId());
            for (RequiredQuest requiredQuest : startElement.getRequiredQuests()) {
                Optional<Long> mostRecentTime = this.questLogSession.findMostRecentTimeForQuestAndOutput(questLogs, requiredQuest.getRequiredQuestId(), requiredQuest.getOutputId());
                if (mostRecentTime.isPresent()) {
                    if (requiredQuest.getHoursWait() == 0 || DateUtils.hoursSince(mostRecentTime.get()) >= requiredQuest.getHoursWait()) continue;
                    return this.noAccess(I18n.getLabel("quest.played-required-too-recently"));
                }
                return this.noAccess(I18n.getLabel("quest.not-played-required-quest"));
            }
        }
        return this.fullAccess();
    }
}

