/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.requirementcheck.check;

import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.requirementcheck.check.QuestRequirementCheck;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;

public class ScriptQuestPlayCheck
extends QuestRequirementCheck {
    private static final Log log = Log.getLogger(ScriptQuestPlayCheck.class.getName());

    @Override
    public QuestRequirementCheckResponse performCheck(ECPlayer player, QuestStartElement startElement) {
        RuleScriptResponse response = this.executePreConditionCheck(player, startElement);
        if (Boolean.FALSE.equals(response.success())) {
            return this.noAccess(response.promptRequest().getMessage());
        }
        return this.fullAccess();
    }

    private RuleScriptResponse executePreConditionCheck(ECPlayer player, QuestStartElement startElement) {
        if (startElement.getPreConditionScript() == null || startElement.getPreConditionScript().isBlank()) {
            return RuleScriptResponse.rulePassed();
        }
        try {
            return ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(startElement.getPreConditionScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute().result();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error running pre condition script for quest %s", startElement.getId()), ex);
            throw new QuestException(ex);
        }
    }
}

