/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.state;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.state.PlayerQuestState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PlayerQuestData {
    private final ECPlayer player;
    private Integer trackedQuestId = null;
    private final Map<Integer, PlayerQuestState> inProgressQuestMap = new HashMap<Integer, PlayerQuestState>();
    private final Lock lock = new ReentrantLock();

    public PlayerQuestData(ECPlayer player) {
        this.player = player;
    }

    public ECPlayer getPlayer() {
        return this.player;
    }

    public PlayerQuestState getTrackedQuestState() {
        if (this.trackedQuestId == null) {
            return null;
        }
        if (!this.isQuestInProgress(this.trackedQuestId)) {
            throw new IllegalArgumentException("Players tracked quest is not on their in progress quest list");
        }
        return this.inProgressQuestMap.get(this.trackedQuestId);
    }

    public boolean hasTrackedQuest() {
        return this.trackedQuestId != null;
    }

    public boolean isTrackedQuest(int questId) {
        return this.hasTrackedQuest() && this.trackedQuestId == questId;
    }

    public void addQuestStateToInProgress(PlayerQuestState questState) {
        if (this.isQuestInProgress(questState.getQuest().getId())) {
            throw new IllegalArgumentException(String.format("Quest %s already in progress by player", questState.getQuest().getId()));
        }
        this.inProgressQuestMap.put(questState.getQuest().getId(), questState);
    }

    public void setTrackedQuest(int questId) {
        if (!this.isQuestInProgress(questId)) {
            throw new IllegalArgumentException(String.format("Invalid quest ID: %s", questId));
        }
        this.trackedQuestId = questId;
    }

    public void stopTrackingCurrentQuest() {
        this.trackedQuestId = null;
    }

    public void removeInProgressQuest(Integer questId) {
        this.inProgressQuestMap.remove(questId);
        if (this.trackedQuestId != null && Objects.equals(this.trackedQuestId, questId)) {
            this.trackedQuestId = null;
        }
    }

    public List<PlayerQuestState> getAllInProgressQuestStates() {
        return this.inProgressQuestMap.values().stream().toList();
    }

    public boolean isQuestInProgress(int questId) {
        return this.inProgressQuestMap.containsKey(questId);
    }

    public PlayerQuestState getStateForQuest(int questId) {
        return this.inProgressQuestMap.get(questId);
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public void unlock() {
        this.lock.unlock();
    }
}

