/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.state;

import com.equestricraft.common.Argb;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.QuestStopwatchElement;
import com.equestricraft.core.quest.element.QuestTimerElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycleStatus;
import com.equestricraft.core.quest.element.lifecycle.QuestStopwatchElementLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestTimerElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.ActiveQuestStopwatch;
import com.equestricraft.core.quest.state.ActiveQuestTimer;
import com.equestricraft.groovy.GroovyScriptSessionData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlayerQuestState {
    private final QuestPlayer player;
    private final Quest quest;
    private final Date startTime;
    private int firstXpReward;
    private int replayXpReward;
    private double firstMoneyReward;
    private double replayMoneyReward;
    private final Set<QuestElementLifecycle<?>> elementLifecycles;
    private final Set<QuestConversationElementLifecycle<?>> conversationElementLifecycles;
    private final GroovyScriptSessionData groovyScriptSessionData;

    public PlayerQuestState(QuestPlayer player, Quest quest) {
        this(player, quest, new Date(), quest.getRewards().getFirstXp(), quest.getRewards().getReplayXp(), quest.getRewards().getFirstMoney(), quest.getRewards().getReplayMoney(), PlayerQuestState.buildQuestElementLifecycles(player, quest.getElements()), new LinkedHashSet(0), GroovyScriptSessionData.createNewSession());
    }

    private static Set<QuestElementLifecycle<?>> buildQuestElementLifecycles(QuestPlayer player, List<QuestElement> questElements) {
        return questElements.stream().map(e -> e.getNewLifecycle(player)).collect(Collectors.toSet());
    }

    public PlayerQuestState(QuestPlayer player, Quest quest, Date startTime, int firstXpReward, int replayXpReward, double firstMoneyReward, double replayMoneyReward, Set<QuestElementLifecycle<?>> elementLifecycles, Set<QuestConversationElementLifecycle<?>> conversationElementLifecycles, GroovyScriptSessionData groovyScriptSessionData) {
        this.player = player;
        this.quest = quest;
        this.startTime = startTime;
        this.firstXpReward = firstXpReward;
        this.replayXpReward = replayXpReward;
        this.firstMoneyReward = firstMoneyReward;
        this.replayMoneyReward = replayMoneyReward;
        this.elementLifecycles = elementLifecycles;
        this.conversationElementLifecycles = conversationElementLifecycles;
        this.groovyScriptSessionData = groovyScriptSessionData;
    }

    public QuestPlayer getPlayer() {
        return this.player;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Map<String, ActiveQuestStopwatch> getStopwatches() {
        return this.getActiveElementLifecycles().filter(QuestStopwatchElementLifecycle.class::isInstance).map(QuestStopwatchElementLifecycle.class::cast).map(l -> new ActiveQuestStopwatch(((QuestStopwatchElement)l.getElement()).getNameKey(), l.getStartTime(), ((QuestStopwatchElement)l.getElement()).isSilentStopwatch())).collect(Collectors.toMap(ActiveQuestStopwatch::getIdentifier, Function.identity()));
    }

    public Map<String, ActiveQuestTimer> getTimers() {
        return this.getActiveElementLifecycles().filter(QuestTimerElementLifecycle.class::isInstance).map(QuestTimerElementLifecycle.class::cast).map(l -> new ActiveQuestTimer(((QuestTimerElement)l.getElement()).getNameKey(), l.getEndTime(), Argb.ARGB_RED, ((QuestTimerElement)l.getElement()).isSilentTimer())).collect(Collectors.toMap(ActiveQuestTimer::getIdentifier, Function.identity()));
    }

    public int getFirstXpReward() {
        return this.firstXpReward;
    }

    public void setFirstXpReward(int firstXpReward) {
        this.firstXpReward = firstXpReward;
    }

    public int getReplayXpReward() {
        return this.replayXpReward;
    }

    public void setReplayXpReward(int replayXpReward) {
        this.replayXpReward = replayXpReward;
    }

    public double getFirstMoneyReward() {
        return this.firstMoneyReward;
    }

    public void setFirstMoneyReward(double firstMoneyReward) {
        this.firstMoneyReward = firstMoneyReward;
    }

    public double getReplayMoneyReward() {
        return this.replayMoneyReward;
    }

    public void setReplayMoneyReward(double replayMoneyReward) {
        this.replayMoneyReward = replayMoneyReward;
    }

    public <T extends QuestElement> Stream<QuestElementLifecycle<T>> getElementLifecycles() {
        return this.elementLifecycles.stream();
    }

    public <T extends QuestElement> Stream<QuestElementLifecycle<T>> getActiveElementLifecycles() {
        return this.elementLifecycles.stream().filter(QuestElementLifecycle::isActive);
    }

    public Stream<QuestObjective> getActiveObjectives() {
        return this.getActiveElementLifecycles().map(QuestElementLifecycle::getElement).filter(QuestObjective.class::isInstance).map(QuestObjective.class::cast);
    }

    public boolean isElementCompleted(QuestElement element) {
        return this.elementLifecycles.stream().filter(l -> l.getStatus() == QuestElementLifecycleStatus.DEACTIVATED).anyMatch(l -> ((QuestElement)l.getElement()).equals(element));
    }

    public <E extends QuestElement, L extends QuestElementLifecycle<E>> L requireElementLifecycle(E questElement) {
        return (L)this.elementLifecycles.stream().filter(s -> ((QuestElement)s.getElement()).equals(questElement)).findFirst().orElseThrow();
    }

    public <E extends QuestConversationElement, L extends QuestConversationElementLifecycle<E>> L requireConversationElementLifecycle(E questElement) {
        return (L)this.conversationElementLifecycles.stream().filter(s -> ((QuestConversationElement)s.getConversationElement()).equals(questElement)).findFirst().orElseGet(() -> {
            QuestConversationElementLifecycle<?> newElement = questElement.getNewLifecycle(this.player);
            this.conversationElementLifecycles.add(newElement);
            return newElement;
        });
    }

    public GroovyScriptSessionData getGroovyScriptSessionData() {
        return this.groovyScriptSessionData;
    }

    public boolean allowSave() {
        return this.getActiveElementLifecycles().allMatch(QuestElementLifecycle::allowSaveWhenActive);
    }

    public boolean allowPause() {
        return this.getActiveElementLifecycles().allMatch(QuestElementLifecycle::allowPauseWhenActive);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream2 = new DataOutputStream(byteArrayOutputStream);
        outputStream2.writeLong(this.startTime.getTime());
        outputStream2.writeInt(this.firstXpReward);
        outputStream2.writeInt(this.replayXpReward);
        outputStream2.writeDouble(this.firstMoneyReward);
        outputStream2.writeDouble(this.replayMoneyReward);
        outputStream2.writeInt(this.elementLifecycles.size());
        for (QuestElementLifecycle<?> questElementLifecycle : this.elementLifecycles) {
            outputStream2.writeUTF(((QuestElement)questElementLifecycle.getElement()).getId().toString());
            questElementLifecycle.serialize(outputStream2);
        }
        outputStream2.writeInt(this.conversationElementLifecycles.size());
        for (QuestConversationElementLifecycle questConversationElementLifecycle : this.conversationElementLifecycles) {
            outputStream2.writeUTF(((QuestConversationElement)questConversationElementLifecycle.getConversationElement()).getId().toString());
            questConversationElementLifecycle.serialize(outputStream2);
        }
        this.groovyScriptSessionData.serialize(outputStream2);
        return byteArrayOutputStream.toByteArray();
    }

    public static PlayerQuestState deserialize(QuestPlayer player, Quest quest, byte[] bytes) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        DataInputStream inputStream2 = new DataInputStream(byteArrayInputStream);
        long startTimeMillis = inputStream2.readLong();
        Date startTime = new Date(startTimeMillis);
        int firstXpReward = inputStream2.readInt();
        int replayXpReward = inputStream2.readInt();
        double firstMoneyReward = inputStream2.readDouble();
        double replayMoneyReward = inputStream2.readDouble();
        int elementLifecycleCount = inputStream2.readInt();
        LinkedHashSet elementLifecycles = new LinkedHashSet(elementLifecycleCount);
        for (int i = 0; i < elementLifecycleCount; ++i) {
            UUID id = UUID.fromString(inputStream2.readUTF());
            QuestElement element = quest.getElementById(id);
            QuestElementLifecycle<?> lifecycle = element.getNewLifecycle(player);
            lifecycle.deserialize(inputStream2);
            elementLifecycles.add(lifecycle);
        }
        int conversationElementLifecycleCount = inputStream2.readInt();
        LinkedHashSet conversationElementLifecycles = new LinkedHashSet(conversationElementLifecycleCount);
        for (int i = 0; i < conversationElementLifecycleCount; ++i) {
            UUID id = UUID.fromString(inputStream2.readUTF());
            QuestConversationElement conversationElement = quest.getElements().stream().filter(QuestConversationObjective.class::isInstance).map(QuestConversationObjective.class::cast).flatMap(o -> o.getElements().stream()).filter(ce -> ce.getId().equals(id)).findFirst().orElseThrow();
            QuestConversationElementLifecycle<?> lifecycle = conversationElement.getNewLifecycle(player);
            lifecycle.deserialize(inputStream2);
            conversationElementLifecycles.add(lifecycle);
        }
        GroovyScriptSessionData sessionData = GroovyScriptSessionData.deserialize(inputStream2);
        return new PlayerQuestState(player, quest, startTime, firstXpReward, replayXpReward, firstMoneyReward, replayMoneyReward, elementLifecycles, conversationElementLifecycles, sessionData);
    }
}

