/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.state;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.core.quest.state.QuestPlayerStateSession;
import com.equestricraft.core.quest.state.persisted.QuestPlayerState;
import com.equestricraft.core.quest.state.persisted.QuestPlayerStateRepository;
import com.equestricraft.logging.Log;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;

public class QuestPlayerStateSessionImpl
implements QuestPlayerStateSession {
    @Service
    private QuestPlayerStateRepository questPlayerStateRepository;
    @Service
    private QuestPlaySession questPlaySession;
    @Service
    private QuestRepository questRepository;
    @Service
    private PlayerRepository playerRepository;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private static final Log log = Log.getLogger(QuestPlayerStateSessionImpl.class.getName());

    @Override
    public PlayerQuestData loadQuestDataForPlayer(QuestPlayer player) {
        PlayerQuestData sessionData = new PlayerQuestData(player);
        Integer trackedQuestId = null;
        List<QuestPlayerState> progressList = this.questPlayerStateRepository.findByPlayer(player.getId());
        for (QuestPlayerState progress : progressList) {
            Quest quest = (Quest)this.questRepository.findByKey(progress.getQuestId());
            try {
                PlayerQuestState playerQuestProgress = PlayerQuestState.deserialize(player, quest, progress.getProgress());
                if (progress.isTracked()) {
                    if (trackedQuestId != null) {
                        log.error("Player {} has more than one tracked quest in persisted data", (Object)player.getIgn());
                    } else {
                        trackedQuestId = quest.getId();
                    }
                }
                sessionData.addQuestStateToInProgress(playerQuestProgress);
            }
            catch (Exception ex) {
                log.error(String.format("Error deserializing progress data for quest %s for player %s", quest.getName(), player.getIgn()), ex);
            }
        }
        if (trackedQuestId != null) {
            sessionData.setTrackedQuest(trackedQuestId);
        }
        return sessionData;
    }

    @Override
    public void persistQuestDataForPlayer(ECPlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        this.removeExistingData(questPlayer);
        PlayerQuestData sessionData = questPlayer.getPlayerQuestData();
        for (PlayerQuestState questProgress : sessionData.getAllInProgressQuestStates()) {
            if (!questProgress.allowSave()) continue;
            try {
                byte[] data = questProgress.serialize();
                boolean isTracked = sessionData.isTrackedQuest(questProgress.getQuest().getId());
                QuestPlayerState questPlayerProgress = new QuestPlayerState(questProgress.getQuest().getId(), player.getId(), data, isTracked);
                this.questPlayerStateRepository.add(questPlayerProgress);
            }
            catch (IOException ex) {
                log.error(String.format("Error persisting quest state data for quest %s and player %s", questProgress.getQuest().getName(), player.getIgn()), ex);
            }
        }
    }

    private void removeExistingData(QuestPlayer player) {
        List<QuestPlayerState> playersCurrentPersistedData = this.questPlayerStateRepository.findByPlayer(player.getId());
        for (QuestPlayerState data : playersCurrentPersistedData) {
            this.questPlayerStateRepository.remove(data);
        }
    }

    @Override
    public int resetStateForQuestForAllPlayers(Quest quest) {
        LinkedHashSet<ECPlayer> affectedPlayers = new LinkedHashSet<ECPlayer>();
        List<QuestPlayerState> progressList = this.questPlayerStateRepository.findByQuest(quest.getId());
        for (QuestPlayerState questPlayerState : progressList) {
            this.questPlayerStateRepository.remove(questPlayerState);
            ECPlayer player = (CorePlayer)this.playerRepository.findByKey(questPlayerState.getPlayerId());
            affectedPlayers.add(player);
        }
        List<ECPlayer> onlinePlayers = this.onlinePlayerCache.getAllPlayers();
        for (ECPlayer player : onlinePlayers) {
            try {
                QuestPlayer questPlayer = player.require(QuestPlayer.class);
                if (!questPlayer.getPlayerQuestData().isQuestInProgress(quest.getId())) continue;
                this.questPlaySession.clearQuestStateForPlayer(quest, questPlayer);
                questPlayer.getPlayerQuestData().removeInProgressQuest(quest.getId());
                affectedPlayers.add(player);
            }
            catch (Exception ex) {
                log.error(String.format("Error resetting quest %s for player %s", quest, player), ex);
            }
        }
        String string = I18n.getLabel("quest.reset-due-to-update", quest.getName());
        for (ECPlayer player : affectedPlayers) {
            player.notify(string);
        }
        return affectedPlayers.size();
    }

    @Override
    public boolean isQuestInProgress(int questId) {
        boolean onlinePlayerHasInProgress = this.onlinePlayerCache.getAllPlayers().stream().map(p -> p.require(QuestPlayer.class)).anyMatch(p -> p.isQuestInProgress(questId));
        if (onlinePlayerHasInProgress) {
            return true;
        }
        List<QuestPlayerState> persisted = this.questPlayerStateRepository.findByQuest(questId);
        return !persisted.isEmpty();
    }
}

