/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.state.persisted;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.quest.state.persisted.QuestPlayerStateKey;
import java.util.Objects;

public class QuestPlayerState
implements RepositoryEntity<QuestPlayerStateKey> {
    private final QuestPlayerStateKey key;
    private final byte[] progress;
    private final boolean isTracked;

    public QuestPlayerState(int questId, int playerId, byte[] progress, boolean isTracked) {
        this.key = new QuestPlayerStateKey(questId, playerId);
        this.progress = progress;
        this.isTracked = isTracked;
    }

    @Override
    public QuestPlayerStateKey getKey() {
        return this.key;
    }

    public int getQuestId() {
        return this.getKey().questId();
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public byte[] getProgress() {
        return this.progress;
    }

    public boolean isTracked() {
        return this.isTracked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestPlayerState that = (QuestPlayerState)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

