/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.state.persisted;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.quest.state.persisted.QuestPlayerState;
import com.equestricraft.core.quest.state.persisted.QuestPlayerStateKey;
import java.util.List;

public class QuestPlayerStateDatabase
implements RepositoryDatasource<QuestPlayerState, QuestPlayerStateKey> {
    private static final String COLUMN_QUEST_ID = "QUEST_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_PROGRESS = "PROGRESS";
    private static final String COLUMN_IS_TRACKED = "IS_TRACKED";

    @Override
    public void create(QuestPlayerState questPlayerState) {
        Query.insertInto("QUEST_PLAYER_STATE").columns(QueryColumn.column(COLUMN_QUEST_ID, questPlayerState.getQuestId()), QueryColumn.column(COLUMN_PLAYER_ID, questPlayerState.getPlayerId()), QueryColumn.column(COLUMN_PROGRESS, questPlayerState.getProgress()), QueryColumn.column(COLUMN_IS_TRACKED, questPlayerState.isTracked())).execute();
    }

    @Override
    public List<QuestPlayerState> retrieveAll() {
        return Query.selectAllFrom("QUEST_PLAYER_STATE").getList(this::getFromResultRow);
    }

    private QuestPlayerState getFromResultRow(ResultRow row) {
        int questId = row.getInt(COLUMN_QUEST_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        byte[] progress = row.getByteArray(COLUMN_PROGRESS);
        boolean isTracked = row.getBoolean(COLUMN_IS_TRACKED);
        return new QuestPlayerState(questId, playerId, progress, isTracked);
    }

    @Override
    public void update(QuestPlayerState questPlayerState) {
        Query.update("QUEST_PLAYER_STATE").set(QueryColumn.column(COLUMN_QUEST_ID, questPlayerState.getQuestId()), QueryColumn.column(COLUMN_PLAYER_ID, questPlayerState.getPlayerId()), QueryColumn.column(COLUMN_PROGRESS, questPlayerState.getProgress()), QueryColumn.column(COLUMN_IS_TRACKED, questPlayerState.isTracked())).execute();
    }

    @Override
    public void deleteByKey(QuestPlayerStateKey questPlayerStateKey) {
        Query.deleteFrom("QUEST_PLAYER_STATE").where(QueryColumn.column(COLUMN_QUEST_ID, questPlayerStateKey.questId()), QueryColumn.column(COLUMN_PLAYER_ID, questPlayerStateKey.playerId())).execute();
    }
}

