/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.storygroup;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.quest.storygroup.QuestStoryGroup;
import java.util.List;

public class QuestStoryGroupDatabase
implements RepositoryDatasource<QuestStoryGroup, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_PARENT_GROUP_ID = "PARENT_GROUP_ID";

    @Override
    public List<QuestStoryGroup> retrieveAll() {
        return Query.selectAllFrom("QUEST_STORY_GROUP").getList(this::getQuestStoryGroupFromResultRow);
    }

    private QuestStoryGroup getQuestStoryGroupFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        Integer parentGroupId = row.getNullableInt(COLUMN_PARENT_GROUP_ID);
        return new QuestStoryGroup(id, name, description, parentGroupId);
    }
}

