/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.rank;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.Argb;
import com.equestricraft.core.rank.Rank;
import java.util.List;

public class RankDatabase
implements RepositoryDatasource<Rank, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_XP_THRESHOLD = "XP_THRESHOLD";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_MAX_HORSES = "MAX_HORSES";

    @Override
    public List<Rank> retrieveAll() {
        return Query.selectAllFrom("PLAYER_RANK").orderBy("XP_THRESHOLD ASC").getList(this::getFromResultRow);
    }

    private Rank getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        int xpThreshold = row.getInt(COLUMN_XP_THRESHOLD);
        Argb color = row.getArgbColor(COLUMN_COLOR);
        int maxHorses = row.getInt(COLUMN_MAX_HORSES);
        return new Rank(id, name, xpThreshold, color, maxHorses);
    }
}

