/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.rank;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.rank.RankDatabase;
import java.util.Comparator;
import java.util.Optional;

public class RankRepository
extends Repository<Rank, Integer> {
    @Service
    private RankDatabase rankDatabase;

    @Override
    protected RepositoryDatasource<Rank, Integer> getDatasource() {
        return this.rankDatabase;
    }

    public Optional<Rank> getRankAfterXp(int xp) {
        RepositorySearchQuery<Rank> searchQuery = this.createSearchQuery();
        searchQuery.sort(Comparator.comparingInt(Rank::getXpThreshold));
        searchQuery.filter(r -> r.getXpThreshold() > xp);
        return searchQuery.single();
    }
}

