/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.rank;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.rank.RankRepository;
import com.equestricraft.core.rank.RankSession;
import java.util.Comparator;
import java.util.List;

public class RankSessionImpl
implements RankSession {
    @Service
    private RankRepository rankRepository;

    @Override
    public Rank getFirstRank() {
        List ranks = this.rankRepository.findAll();
        if (ranks.isEmpty()) {
            throw new IllegalArgumentException("No ranks found!");
        }
        return (Rank)ranks.get(0);
    }

    @Override
    public Rank getRankForXp(int xp) {
        List ranks = this.rankRepository.findAll();
        if (ranks.isEmpty()) {
            throw new IllegalArgumentException("No ranks found!");
        }
        ranks.sort(Comparator.comparingInt(Rank::getXpThreshold).reversed());
        for (Rank rank : ranks) {
            if (rank.getXpThreshold() > xp) continue;
            return rank;
        }
        throw new IllegalArgumentException(String.format("No rank found for XP %s", xp));
    }
}

