/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.registrationorganization;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganization;
import java.util.List;

public class HorseRegistrationOrganizationDatabase
implements RepositoryDatasource<HorseRegistrationOrganization, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_CONDITION_SCRIPT = "CONDITION_SCRIPT";
    private static final String COLUMN_PRICE = "PRICE";
    private static final String COLUMN_REGISTRATION_NUMBER_PREFIX = "REGISTRATION_NUMBER_PREFIX";
    private static final String COLUMN_NEXT_REGISTRATION_NUMBER = "NEXT_REGISTRATION_NUMBER";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_ORGANIZATION_ID = "ORGANIZATION_ID";
    private static final String COLUMN_NPC_ID = "NPC_ID";

    @Override
    public List<HorseRegistrationOrganization> retrieveAll() {
        return Query.selectAllFrom("HORSE_REGISTRATION_ORGANIZATION").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private HorseRegistrationOrganization getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        List<Integer> npcIds = this.getNpcsIdsForOrganization(id);
        String conditionScript = row.getString(COLUMN_CONDITION_SCRIPT);
        double price = row.getDouble(COLUMN_PRICE);
        String idNumberPrefix = row.getString(COLUMN_REGISTRATION_NUMBER_PREFIX);
        int nextIdNumber = row.getInt(COLUMN_NEXT_REGISTRATION_NUMBER);
        return new HorseRegistrationOrganization(id, name, description, npcIds, conditionScript, price, idNumberPrefix, nextIdNumber);
    }

    private List<Integer> getNpcsIdsForOrganization(int organizationId) {
        return Query.selectAllFrom("HORSE_REGISTRATION_ORGANIZATION_NPC").where(QueryColumn.column(COLUMN_ORGANIZATION_ID, organizationId)).getList(row -> row.getInt(COLUMN_NPC_ID));
    }

    @Override
    public void update(HorseRegistrationOrganization horseRegistrationOrganization) {
        Query.update("HORSE_REGISTRATION_ORGANIZATION").set(QueryColumn.column(COLUMN_NEXT_REGISTRATION_NUMBER, horseRegistrationOrganization.getNextRegistrationNumber())).where(QueryColumn.column(COLUMN_ID, horseRegistrationOrganization.getId())).execute();
    }
}

