/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.repeatingtask;

import com.equestricraft.base.task.SchedulerTask;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.core.repeatingtask.RepeatingTask;
import com.equestricraft.logging.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public class RepeatingTaskManager {
    public static final RepeatingTaskManager instance = new RepeatingTaskManager();
    private final List<RepeatingTask> tasks = new LinkedList<RepeatingTask>();
    private static final Log log = Log.getLogger(RepeatingTaskManager.class.getName());

    public static RepeatingTaskManager getInstance() {
        return instance;
    }

    private RepeatingTaskManager() {
    }

    public void start() {
        this.scanForTasks();
        this.startAllTasks();
    }

    private void scanForTasks() {
        List<Class<RepeatingTask>> classes = ReflectionHelper.scanClassesExtendingType(RepeatingTask.class);
        classes.stream().map(Services::getService).forEach(this.tasks::add);
    }

    private void startAllTasks() {
        this.tasks.forEach(this::restartTask);
    }

    public void restartTask(String name) {
        this.findTaskByName(name).ifPresent(this::restartTask);
    }

    private Optional<RepeatingTask> findTaskByName(String name) {
        return this.tasks.stream().filter(t -> t.name().equals(name)).findAny();
    }

    private void restartTask(RepeatingTask task) {
        this.stopIfRunning(task);
        SchedulerTask asyncTask = TaskScheduler.executeAsyncTask(() -> this.checkAndRun(task), task.delay(), task.period());
        task.setAsyncTask(asyncTask);
        this.logOutput("Started task {}", task.name());
    }

    private void stopIfRunning(RepeatingTask task) {
        SchedulerTask asyncTask = task.getAsyncTask();
        if (asyncTask != null) {
            asyncTask.cancel();
            this.logOutput("Stopped task {}", task.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkAndRun(RepeatingTask task) {
        if (task.shouldRun()) {
            this.logOutput("Task {} is about to run", task.name());
            long startTime = System.currentTimeMillis();
            Timer monitoringTimer = this.createMonitoringTimer(task, startTime);
            try {
                task.execute();
                long endTime = System.currentTimeMillis();
                this.logOutput("Task {} has run in {}ms", task.name(), endTime - startTime);
            }
            catch (Exception ex) {
                log.error(String.format("Task %s threw an error while running", task.name()), ex);
            }
            finally {
                monitoringTimer.cancel();
            }
        } else {
            this.logOutput("Task {} will not run right now", task.name());
        }
    }

    private Timer createMonitoringTimer(final RepeatingTask task, final long startTime) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long runningTimeSeconds = (System.currentTimeMillis() - startTime) / 1000L;
                log.warn("Task {} has been running for {} seconds", (Object)task.name(), (Object)runningTimeSeconds);
            }
        }, 60000L, 60000L);
        return timer;
    }

    public List<String> getNamesOfTasks() {
        return this.tasks.stream().map(RepeatingTask::name).toList();
    }

    public void stopAllTasks() {
        this.tasks.forEach(this::stopIfRunning);
    }

    private void logOutput(String message, Object ... param) {
        log.debug(String.format("[REPEATING TASK] %s", message), param);
    }

    boolean areAllTasksActive() {
        return this.tasks.stream().allMatch(RepeatingTask::isActive);
    }
}

