/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.response;

import com.equestricraft.base.response.Response;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.core.player.ECPlayer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public abstract class ResponseHandler {
    private static final ResponseHandler responseHandler = ResponseHandler.createResponseHandler();

    private static ResponseHandler createResponseHandler() {
        List<Class<ResponseHandler>> impls = ReflectionHelper.scanClassesExtendingType(ResponseHandler.class);
        Class impl = (Class)impls.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find implementation for ResponseHandler"));
        try {
            return (ResponseHandler)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Error with ResponseHandler implementation");
        }
    }

    public static void handleResponse(ECPlayer player, Response response) {
        responseHandler.handleResponseImpl(player, response);
    }

    protected abstract void handleResponseImpl(ECPlayer var1, Response var2);
}

