/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.salesbarn;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.age.HorseAgeSession;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.create.HorseCreateException;
import com.equestricraft.core.horse.create.HorseCreateRequest;
import com.equestricraft.core.horse.create.HorseCreateSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.salesbarn.SalesBarnHorseInfo;
import com.equestricraft.core.salesbarn.SalesBarnPurchaseException;
import com.equestricraft.core.salesbarn.SalesBarnPurchaseResponse;
import com.equestricraft.core.salesbarn.SalesBarnSession;
import com.equestricraft.core.salesbarn.group.SalesBarnStallGroup;
import com.equestricraft.core.salesbarn.group.SalesBarnStallGroupRepository;
import com.equestricraft.core.salesbarn.log.SalesBarnPurchaseLogSession;
import com.equestricraft.core.salesbarn.stall.SalesBarnStall;
import com.equestricraft.core.salesbarn.stall.SalesBarnStallRepository;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class SalesBarnSessionImpl
implements SalesBarnSession {
    @Service
    private SalesBarnStallRepository salesBarnStallRepository;
    @Service
    private SalesBarnPurchaseLogSession salesBarnPurchaseLogSession;
    @Service
    private SalesBarnStallGroupRepository salesBarnStallGroupRepository;
    @Service
    private HorseCreateSession horseCreateSession;
    @Service
    private HorseAgeSession horseAgeSession;

    @Override
    public SalesBarnPurchaseResponse purchaseHorse(ECPlayer player, int stallId, String name) throws SalesBarnPurchaseException {
        try {
            SalesBarnStall stall = (SalesBarnStall)this.salesBarnStallRepository.findByKey(stallId);
            SalesBarnStallGroup group = (SalesBarnStallGroup)this.salesBarnStallGroupRepository.findByKey(stall.getGroupId());
            if (!player.getEconomy().hasBalance(group.getPrice())) {
                throw new SalesBarnPurchaseException(I18n.getLabel("sales-barn.purchase.not-enough-money"));
            }
            this.ensurePlayerCanBuyHorse(player, group);
            HorseCoatDetails coatDetails = HorseCoatDetails.Builder.start().withColor(stall.getColor()).withMarking(stall.getMarking()).withGrayScale(Boolean.TRUE.equals(stall.getGray()) ? 1.0f : 0.0f).complete();
            HorseCreateRequest horseCreateRequest = HorseCreateRequest.Builder.start().withOrigin(HorseOrigin.SALES_BARN).withName(name).withOwner(player).withGender(stall.getGender()).withAgeMonths(stall.getAgeMonths()).withCoatDetails(coatDetails).withCurrentValue(group.getPrice()).complete();
            EQHorse newHorse = this.horseCreateSession.createHorse(horseCreateRequest);
            SingleAccountEconomyResponse economyResponse = player.getEconomy().withdraw(group.getPrice(), I18n.getLabel("sales-barn.purchase.transaction-line", group.getName()), "Sales Barn");
            this.salesBarnPurchaseLogSession.logPurchase(player.getId(), group.getId());
            this.resetStall(stall);
            return new SalesBarnPurchaseResponse(newHorse, economyResponse.amountFormatted(), economyResponse.balanceFormatted());
        }
        catch (EconomyException | HorseCreateException ex) {
            throw new SalesBarnPurchaseException(ex);
        }
    }

    private void ensurePlayerCanBuyHorse(ECPlayer player, SalesBarnStallGroup group) throws SalesBarnPurchaseException {
        if (group.getPurchaseCoolDownHours() <= 0) {
            return;
        }
        Optional<Duration> duration = this.salesBarnPurchaseLogSession.getDurationSinceLastPurchaseForPlayer(player.getId(), group.getId());
        if (duration.isPresent()) {
            int hoursSinceLastPurchase = (int)duration.get().toHours();
            int hoursToWait = group.getPurchaseCoolDownHours() - hoursSinceLastPurchase;
            if (hoursToWait > 0) {
                throw new SalesBarnPurchaseException(I18n.getLabel("sales-barn.purchase.cool-down", hoursToWait));
            }
        }
    }

    @Override
    public void fillEmptyStalls() {
        this.salesBarnStallRepository.streamAll().filter(this::isEmpty).forEach(this::resetStall);
    }

    private boolean isEmpty(SalesBarnStall stall) {
        return stall.getGender() == null || stall.getAgeMonths() == null;
    }

    private void resetStall(SalesBarnStall stall) {
        SalesBarnStallGroup group = (SalesBarnStallGroup)this.salesBarnStallGroupRepository.findByKey(stall.getGroupId());
        HorseGender gender = HorseGender.getRandomGender();
        int ageMonths = NumberUtils.randomIntInRange(group.getMinimumAgeMonths(), group.getMaximumAgeMonths());
        HorseCoatColor color = ListUtils.getRandomItem(group.getColors());
        HorseCoatMarking marking = ListUtils.getRandomItem(group.getMarkings());
        boolean gray = (double)ThreadLocalRandom.current().nextFloat() >= 0.8;
        stall.setGender(gender);
        stall.setAgeMonths(ageMonths);
        stall.setColor(color);
        stall.setMarking(marking);
        stall.setGray(gray);
        stall.save();
    }

    @Override
    public SalesBarnHorseInfo retrieveInfoForHorseInStall(int stallId) {
        SalesBarnStall stall = (SalesBarnStall)this.salesBarnStallRepository.findByKey(stallId);
        return this.retrieveInfoForHorseInStall(stall);
    }

    @Override
    public SalesBarnHorseInfo retrieveInfoForHorseInStall(SalesBarnStall stall) {
        SalesBarnStallGroup group = (SalesBarnStallGroup)this.salesBarnStallGroupRepository.findByKey(stall.getGroupId());
        return new SalesBarnHorseInfo(stall.getId(), stall.getGender().getTranslatedName(), this.horseAgeSession.formatAgeInMonths(stall.getAgeMonths()), EconomyUtilities.formatCurrency(group.getPrice()));
    }
}

