/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.salesbarn.group;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.core.salesbarn.group.SalesBarnStallGroup;
import java.util.List;

public class SalesBarnStallGroupDatabase
implements RepositoryDatasource<SalesBarnStallGroup, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_MINIMUM_AGE_MONTHS = "MINIMUM_AGE_MONTHS";
    private static final String COLUMN_MAXIMUM_AGE_MONTHS = "MAXIMUM_AGE_MONTHS";
    private static final String COLUMN_PRICE = "PRICE";
    private static final String COLUMN_ACCESS_SCRIPT = "ACCESS_SCRIPT";
    private static final String COLUMN_PURCHASE_COOL_DOWN_HOURS = "PURCHASE_COOL_DOWN_HOURS";
    private static final String COLUMN_GROUP_ID = "GROUP_ID";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_MARKING = "MARKING";

    @Override
    public List<SalesBarnStallGroup> retrieveAll() {
        return Query.selectAllFrom("SALES_BARN_STALL_GROUP").getList(this::getGroupFromResultRow);
    }

    private SalesBarnStallGroup getGroupFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        int minimumAgeMonths = row.getInt(COLUMN_MINIMUM_AGE_MONTHS);
        int maximumAgeMonths = row.getInt(COLUMN_MAXIMUM_AGE_MONTHS);
        double price = row.getDouble(COLUMN_PRICE);
        String accessScript = row.getString(COLUMN_ACCESS_SCRIPT);
        int purchaseCoolDownHours = row.getInt(COLUMN_PURCHASE_COOL_DOWN_HOURS);
        List<HorseCoatColor> colors = this.getColorsForGroup(id);
        List<HorseCoatMarking> markings = this.getMarkingsForGroup(id);
        return new SalesBarnStallGroup(id, name, minimumAgeMonths, maximumAgeMonths, price, accessScript, purchaseCoolDownHours, colors, markings);
    }

    private List<HorseCoatColor> getColorsForGroup(int groupId) {
        return Query.selectAllFrom("SALES_BARN_STALL_GROUP_COLOR").where(QueryColumn.column(COLUMN_GROUP_ID, groupId)).getList(r -> r.getEnum(COLUMN_COLOR, HorseCoatColor.class));
    }

    private List<HorseCoatMarking> getMarkingsForGroup(int groupId) {
        return Query.selectAllFrom("SALES_BARN_STALL_GROUP_MARKING").where(QueryColumn.column(COLUMN_GROUP_ID, groupId)).getList(r -> r.getEnum(COLUMN_MARKING, HorseCoatMarking.class));
    }
}

