/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.salesbarn.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.salesbarn.log.SalesBarnPurchaseLog;
import java.util.List;

public class SalesBarnPurchaseLogDatabase
implements RepositoryDatasource<SalesBarnPurchaseLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_GROUP_ID = "GROUP_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(SalesBarnPurchaseLog salesBarnPurchaseLog) {
        Query.insertInto("SALES_BARN_PURCHASE_LOG").columns(QueryColumn.column(COLUMN_PLAYER_ID, salesBarnPurchaseLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, salesBarnPurchaseLog.getTimeStamp())).executeGetGeneratedKey(salesBarnPurchaseLog::setId);
    }

    @Override
    public List<SalesBarnPurchaseLog> retrieveAll() {
        return Query.selectAllFrom("SALES_BARN_PURCHASE_LOG").getList(this::getFromResultRow);
    }

    private SalesBarnPurchaseLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        Integer groupId = row.getNullableInt(COLUMN_GROUP_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new SalesBarnPurchaseLog(id, playerId, groupId, timeStamp);
    }
}

