/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.salesbarn.stall;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.salesbarn.stall.SalesBarnStall;
import java.util.List;

public class SalesBarnStallDatabase
implements RepositoryDatasource<SalesBarnStall, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_LOCATION = "LOCATION";
    private static final String COLUMN_GROUP_ID = "GROUP_ID";
    private static final String COLUMN_GENDER = "GENDER";
    private static final String COLUMN_AGE_MONTHS = "AGE_MONTHS";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_MARKING = "MARKING";
    private static final String COLUMN_GRAY = "GRAY";

    @Override
    public List<SalesBarnStall> retrieveAll() {
        return Query.selectAllFrom("SALES_BARN_STALL").getList(this::getFromResultRow);
    }

    private SalesBarnStall getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        DirectionalCoordinate location = row.getDirectionalCoordinate(COLUMN_LOCATION);
        int groupId = row.getInt(COLUMN_GROUP_ID);
        HorseGender gender = row.getNullableEnum(COLUMN_GENDER, HorseGender.class);
        Integer ageMonths = row.getNullableInt(COLUMN_AGE_MONTHS);
        HorseCoatColor color = row.getNullableEnum(COLUMN_COLOR, HorseCoatColor.class);
        HorseCoatMarking marking = row.getNullableEnum(COLUMN_MARKING, HorseCoatMarking.class);
        Boolean gray = row.getNullableBoolean(COLUMN_GRAY);
        return new SalesBarnStall(id, location, groupId, gender, ageMonths, color, marking, gray);
    }

    @Override
    public void update(SalesBarnStall salesBarnStall) {
        Query.update("SALES_BARN_STALL").set(QueryColumn.column(COLUMN_GENDER, salesBarnStall.getGender()), QueryColumn.column(COLUMN_AGE_MONTHS, salesBarnStall.getAgeMonths()), QueryColumn.column(COLUMN_COLOR, salesBarnStall.getColor()), QueryColumn.column(COLUMN_MARKING, salesBarnStall.getMarking()), QueryColumn.column(COLUMN_GRAY, salesBarnStall.getGray())).where(QueryColumn.column(COLUMN_ID, salesBarnStall.getId())).execute();
    }
}

