/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.scheduletask;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.DaysOfWeek;
import com.equestricraft.core.scheduletask.ScheduleTaskRepository;
import java.util.Date;
import java.util.Objects;

public class ScheduleTask
implements RepositoryEntity<String> {
    private final String identifier;
    private final DaysOfWeek daysOfWeek;
    private final String script;
    private Date lastRunTime;

    public ScheduleTask(String identifier, DaysOfWeek daysOfWeek, String script, Date lastRunTime) {
        this.identifier = identifier;
        this.daysOfWeek = daysOfWeek;
        this.script = script;
        this.lastRunTime = lastRunTime;
    }

    @Override
    public String getKey() {
        return this.getIdentifier();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public DaysOfWeek getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public String getScript() {
        return this.script;
    }

    public Date getLastRunTime() {
        return this.lastRunTime;
    }

    public void setLastRunTime(Date lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    @Override
    public void save() {
        Services.getService(ScheduleTaskRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTask that = (ScheduleTask)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

