/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.scheduletask;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.DaysOfWeek;
import com.equestricraft.core.scheduletask.ScheduleTask;
import java.sql.Date;
import java.util.List;

public class ScheduleTaskDatabase
implements RepositoryDatasource<ScheduleTask, String> {
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DAYS_OF_WEEK = "DAYS_OF_WEEK";
    private static final String COLUMN_SCRIPT = "SCRIPT";
    private static final String COLUMN_LAST_RUN_TIME = "LAST_RUN_TIME";

    @Override
    public List<ScheduleTask> retrieveAll() {
        return Query.selectAllFrom("SCHEDULE_TASK").getList(this::getFromResultRow);
    }

    private ScheduleTask getFromResultRow(ResultRow row) {
        String identifier = row.getString(COLUMN_IDENTIFIER);
        DaysOfWeek daysOfWeek = row.getDaysOfWeek(COLUMN_DAYS_OF_WEEK);
        String script = row.getString(COLUMN_SCRIPT);
        Date lastRunTime = row.getNullableDate(COLUMN_LAST_RUN_TIME);
        return new ScheduleTask(identifier, daysOfWeek, script, lastRunTime);
    }

    @Override
    public void update(ScheduleTask scheduleTask) {
        Query.update("SCHEDULE_TASK").set(QueryColumn.column(COLUMN_LAST_RUN_TIME, scheduleTask.getLastRunTime())).where(QueryColumn.column(COLUMN_IDENTIFIER, scheduleTask.getIdentifier())).execute();
    }
}

