/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.scheduletask;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.scheduletask.ScheduleTask;
import com.equestricraft.core.scheduletask.ScheduleTaskRepository;
import com.equestricraft.core.scheduletask.ScheduleTaskSession;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;

public class ScheduleTaskSessionImpl
implements ScheduleTaskSession {
    @Service
    private ScheduleTaskRepository scheduleTaskRepository;
    private static final Log log = Log.getLogger(ScheduleTaskSessionImpl.class.getName());

    @Override
    public void executeDueTasks() {
        Date time = new Date();
        List<ScheduleTask> tasksForToday = this.getTodayTasksNotRunToday();
        for (ScheduleTask task : tasksForToday) {
            try {
                GroovyStandardScriptExecutor.start(task.getScript()).execute();
                task.setLastRunTime(time);
                task.save();
            }
            catch (GroovyException ex) {
                log.error(String.format("Error executing scheduled task %s", task.getIdentifier()), ex);
            }
        }
    }

    private List<ScheduleTask> getTodayTasksNotRunToday() {
        List<ScheduleTask> tasksForToday = this.scheduleTaskRepository.getTodayTasks();
        return tasksForToday.stream().filter(Predicate.not(this::hasTaskRunToday)).toList();
    }

    private boolean hasTaskRunToday(ScheduleTask task) {
        return task.getLastRunTime() != null && DateUtils.daysSince(task.getLastRunTime()) == 0;
    }
}

