/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.season;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APISeasonDto;
import com.equestricraft.common.season.Season;
import java.util.Objects;

public class APISeasonDtoImpl
implements APISeasonDto {
    private final Season season;

    public APISeasonDtoImpl(Season season) {
        this.season = season;
    }

    @Override
    public String getName() {
        return this.season.getType().getTranslatedName();
    }

    @Override
    public APIDurationDto getDurationSinceStart() {
        return new APIDurationDto(this.season.getDurationSinceStart());
    }

    @Override
    public APIDurationDto getDurationRemaining() {
        return new APIDurationDto(this.season.getDurationUntilEnd());
    }

    @Override
    public double getPercentageProgress() {
        return (double)this.season.getPercentageThroughSeason() * 100.0;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APISeasonDtoImpl that = (APISeasonDtoImpl)o;
        return Objects.equals(this.season, that.season);
    }

    public int hashCode() {
        return Objects.hashCode(this.season);
    }

    public String toString() {
        return this.getName();
    }
}

