/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.setting;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.settings.SettingEntry;
import java.util.Optional;

public class SettingDatabase {
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DISPLAY_NAME = "DISPLAY_NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_CURRENT_VALUE = "CURRENT_VALUE";

    public void persistNewSetting(SettingEntry settingEntry) {
        Query.insertInto("SETTING").columns(QueryColumn.column(COLUMN_NAME, settingEntry.key()), QueryColumn.column(COLUMN_DISPLAY_NAME, settingEntry.name()), QueryColumn.column(COLUMN_DESCRIPTION, settingEntry.description()), QueryColumn.column(COLUMN_CURRENT_VALUE, settingEntry.value())).execute();
    }

    public Optional<SettingEntry> retrieveSetting(String key) {
        return Query.selectAllFrom("SETTING").where(QueryColumn.column(COLUMN_NAME, key)).getSingle(this::getFromResultRow);
    }

    private SettingEntry getFromResultRow(ResultRow row) {
        String name = row.getString(COLUMN_NAME);
        String displayName = row.getString(COLUMN_DISPLAY_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        String currentValue = row.getNullableString(COLUMN_CURRENT_VALUE);
        return new SettingEntry(name, displayName, description, currentValue);
    }

    public void updateSetting(SettingEntry settingEntry) {
        Query.update("SETTING").set(QueryColumn.column(COLUMN_DISPLAY_NAME, settingEntry.name()), QueryColumn.column(COLUMN_DESCRIPTION, settingEntry.description()), QueryColumn.column(COLUMN_CURRENT_VALUE, settingEntry.value())).where(QueryColumn.column(COLUMN_NAME, settingEntry.key())).execute();
    }
}

