/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shoe;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.shoe.TractionPercentage;
import java.util.Date;
import java.util.Objects;

public class HorseShoe
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String identifier;
    private final String description;
    private final double speedOffsetPercentage;
    private final double maximumStaminaOffsetPercentage;
    private final long staminaOffsetPerTickOffset;
    private final int durationDays;
    private final double hoofWearReductionPercentage;
    private final double fallOffPercentage;
    private final String model;
    private final TractionPercentage tractionPercentage;

    public HorseShoe(int id, String name, String identifier, String description, double speedOffsetPercentage, double maximumStaminaOffsetPercentage, long staminaOffsetPerTickOffset, int durationDays, double hoofWearReductionPercentage, double fallOffPercentage, String model, TractionPercentage tractionPercentage) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.speedOffsetPercentage = speedOffsetPercentage;
        this.maximumStaminaOffsetPercentage = maximumStaminaOffsetPercentage;
        this.staminaOffsetPerTickOffset = staminaOffsetPerTickOffset;
        this.durationDays = durationDays;
        this.hoofWearReductionPercentage = hoofWearReductionPercentage;
        this.fallOffPercentage = fallOffPercentage;
        this.model = model;
        this.tractionPercentage = tractionPercentage;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public double getSpeedOffsetPercentage() {
        return this.speedOffsetPercentage;
    }

    public double getMaximumStaminaOffsetPercentage() {
        return this.maximumStaminaOffsetPercentage;
    }

    public long getStaminaOffsetPerTickOffset() {
        return this.staminaOffsetPerTickOffset;
    }

    public int getDurationDays() {
        return this.durationDays;
    }

    public Date getMaximumEndTimeForShoeFromNow() {
        return DateUtils.futureDaysOffset(this.getDurationDays());
    }

    public double getHoofWearReductionPercentage() {
        return this.hoofWearReductionPercentage;
    }

    public double getFallOffPercentage() {
        return this.fallOffPercentage;
    }

    public String getModel() {
        return this.model;
    }

    public TractionPercentage getTractionPercentage() {
        return this.tractionPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseShoe horseShoe = (HorseShoe)o;
        return this.id == horseShoe.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

