/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shoe;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.shoe.HorseShoe;
import com.equestricraft.core.shoe.TractionPercentage;
import java.util.List;

public class HorseShoeDatabase
implements RepositoryDatasource<HorseShoe, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_SPEED_OFFSET_PERCENTAGE = "SPEED_OFFSET_PERCENTAGE";
    private static final String COLUMN_MAXIMUM_STAMINA_OFFSET_PERCENTAGE = "MAXIMUM_STAMINA_OFFSET_PERCENTAGE";
    private static final String COLUMN_STAMINA_OFFSET_PER_TICK_OFFSET = "STAMINA_OFFSET_PER_TICK_OFFSET";
    private static final String COLUMN_DURATION_DAYS = "DURATION_DAYS";
    private static final String COLUMN_HOOF_WEAR_REDUCTION_PERCENTAGE = "HOOF_WEAR_REDUCTION_PERCENTAGE";
    private static final String COLUMN_FALL_OFF_PERCENTAGE = "FALL_OFF_PERCENTAGE";
    private static final String COLUMN_MODEL = "MODEL";
    private static final String COLUMN_HARD_TRACTION_PERCENTAGE = "HARD_TRACTION_PERCENTAGE";
    private static final String COLUMN_SOFT_TRACTION_PERCENTAGE = "SOFT_TRACTION_PERCENTAGE";
    private static final String COLUMN_LOOSE_TRACTION_PERCENTAGE = "LOOSE_TRACTION_PERCENTAGE";

    @Override
    public List<HorseShoe> retrieveAll() {
        return Query.selectAllFrom("HORSE_SHOE").getList(this::getFromResultRow);
    }

    private HorseShoe getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        double speedOffsetPercentage = row.getDouble(COLUMN_SPEED_OFFSET_PERCENTAGE);
        double maximumStaminaOffsetPercentage = row.getDouble(COLUMN_MAXIMUM_STAMINA_OFFSET_PERCENTAGE);
        long staminaOffsetPerTickOffset = row.getLong(COLUMN_STAMINA_OFFSET_PER_TICK_OFFSET);
        int durationDays = row.getInt(COLUMN_DURATION_DAYS);
        double hoofWearReductionPercentage = row.getDouble(COLUMN_HOOF_WEAR_REDUCTION_PERCENTAGE);
        double fallOffPercentage = row.getDouble(COLUMN_FALL_OFF_PERCENTAGE);
        String model = row.getString(COLUMN_MODEL);
        double hardTractionPercentage = row.getDouble(COLUMN_HARD_TRACTION_PERCENTAGE);
        double softTractionPercentage = row.getDouble(COLUMN_SOFT_TRACTION_PERCENTAGE);
        double looseTractionPercentage = row.getDouble(COLUMN_LOOSE_TRACTION_PERCENTAGE);
        TractionPercentage tractionPercentage = new TractionPercentage(hardTractionPercentage, softTractionPercentage, looseTractionPercentage);
        return new HorseShoe(id, name, identifier, description, speedOffsetPercentage, maximumStaminaOffsetPercentage, staminaOffsetPerTickOffset, durationDays, hoofWearReductionPercentage, fallOffPercentage, model, tractionPercentage);
    }
}

