/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.shop.Shop;
import java.util.List;

public class ShopDatabase
implements RepositoryDatasource<Shop, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_ACCESS_SCRIPT = "ACCESS_SCRIPT";
    private static final String COLUMN_PRE_PURCHASE_SCRIPT = "PRE_PURCHASE_SCRIPT";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_SHOP_ID = "SHOP_ID";
    private static final String COLUMN_NPC_ID = "NPC_ID";

    @Override
    public List<Shop> retrieveAll() {
        return Query.selectAllFrom("SHOP").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private Shop getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        String accessScript = row.getString(COLUMN_ACCESS_SCRIPT);
        String prePurchaseScript = row.getString(COLUMN_PRE_PURCHASE_SCRIPT);
        List<Integer> npcs = this.getNpcsForShop(id);
        return new Shop(id, name, description, accessScript, prePurchaseScript, npcs);
    }

    private List<Integer> getNpcsForShop(int shopId) {
        return Query.selectAllFrom("SHOP_CLERK").where(QueryColumn.column(COLUMN_SHOP_ID, shopId)).getList(row -> row.getInt(COLUMN_NPC_ID));
    }
}

