/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemRepository;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.shop.Shop;
import com.equestricraft.core.shop.ShopInfo;
import com.equestricraft.core.shop.ShopPurchaseResponse;
import com.equestricraft.core.shop.ShopRepository;
import com.equestricraft.core.shop.ShopSession;
import com.equestricraft.core.shop.item.ShopItem;
import com.equestricraft.core.shop.item.ShopItemInfo;
import com.equestricraft.core.shop.item.ShopItemRepository;
import com.equestricraft.core.shop.log.ShopItemLogSession;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class ShopSessionImpl
implements ShopSession {
    @Service
    private ShopRepository shopRepository;
    @Service
    private ShopItemRepository shopItemRepository;
    @Service
    private ShopItemLogSession shopItemLogSession;
    @Service
    private ECItemRepository ecItemRepository;
    private static final String GROOVY_ALLOW_PURCHASE = "allowPurchase";
    private static final String GROOVY_FAIL_MESSAGE = "failMessage";
    private static final String GROOVY_DISCOUNT_PERCENTAGE = "discountPercentage";
    private static final Log log = Log.getLogger(ShopSessionImpl.class.getName());

    @Override
    public Optional<ShopInfo> retrieveInfoForNpcShop(int npcId) {
        Optional<Shop> shop = this.shopRepository.findShopWithNpc(npcId);
        return shop.map(this::buildShopInfo);
    }

    private ShopInfo buildShopInfo(Shop shop) {
        return new ShopInfo(shop.getId(), shop.getName(), shop.getDescription());
    }

    @Override
    public List<ShopItemInfo> retrieveShopItemsForShop(int shopId) {
        List<ShopItem> shopItems = this.shopItemRepository.findShopItemsByShop(shopId);
        return shopItems.stream().map(this::buildItemInfo).toList();
    }

    private ShopItemInfo buildItemInfo(ShopItem shopItem) {
        ECItem ecItem = (ECItem)this.ecItemRepository.findByKey(shopItem.getItemId());
        boolean inStock = this.isItemInStock(shopItem, 0);
        return new ShopItemInfo(ecItem.getId(), ecItem.getName(), ecItem.getDescription(), ecItem.getModItemName(), shopItem.getId(), EconomyUtilities.formatCurrency(shopItem.getPrice()), inStock);
    }

    private boolean isItemInStock(ShopItem shopItem, int quantity) {
        if (shopItem.getGlobalLimit() != null && shopItem.getGlobalLimitHoursDuration() != null) {
            Duration duration = Duration.ofHours(shopItem.getGlobalLimitHoursDuration().intValue());
            int quantitySold = this.shopItemLogSession.getQuantitySoldOfItemInPastDuration(shopItem.getId(), duration);
            return quantitySold + quantity < shopItem.getGlobalLimit();
        }
        return true;
    }

    private boolean canPlayerBuyWithinLimit(ECPlayer player, ShopItem shopItem, int quantity) {
        if (shopItem.getPlayerLimit() != null && shopItem.getPlayerLimitHoursDuration() != null) {
            Duration duration = Duration.ofHours(shopItem.getPlayerLimitHoursDuration().intValue());
            int quantitySold = player.getShops().getQuantityOfItemBoughtInPastDuration(shopItem.getItemId(), duration);
            return quantitySold + quantity < shopItem.getPlayerLimit();
        }
        return true;
    }

    @Override
    public ShopPurchaseResponse purchaseItemFromShop(ECPlayer player, int shopItemId, int quantity) {
        ShopItem shopItem = (ShopItem)this.shopItemRepository.findByKey(shopItemId);
        Shop shop = (Shop)this.shopRepository.findByKey(shopItem.getShopId());
        ECItem ecItem = (ECItem)this.ecItemRepository.findByKey(shopItem.getItemId());
        if (!this.isItemInStock(shopItem, quantity)) {
            return new ShopPurchaseResponse(false, null, null, I18n.getLabel("shop.purchase.out-of-stock"));
        }
        if (!this.canPlayerBuyWithinLimit(player, shopItem, quantity)) {
            return new ShopPurchaseResponse(false, null, null, I18n.getLabel("shop.purchase.bought-too-many-recently"));
        }
        try {
            PrePurchaseScriptResponse prePurchaseResponse = this.executePrePurchaseScript(player, shop);
            if (!prePurchaseResponse.allowPurchase()) {
                return new ShopPurchaseResponse(false, null, null, prePurchaseResponse.failMessage());
            }
            double pricePerItem = PercentageUtils.decreaseByPercentage(shopItem.getPrice(), prePurchaseResponse.discountPercentage());
            double totalCost = pricePerItem * (double)quantity;
            SingleAccountEconomyResponse economyResponse = player.getEconomy().withdraw(totalCost, I18n.getLabel("shop.purchase.transaction-line", shop.getName()), "Shop");
            this.shopItemLogSession.logShopItemPurchase(player, shopItem, quantity);
            player.getInventory().addItem(ecItem, quantity);
            return new ShopPurchaseResponse(true, economyResponse.amountFormatted(), ecItem, null);
        }
        catch (EconomyException ex) {
            return new ShopPurchaseResponse(false, null, null, ex.getMessage());
        }
    }

    private PrePurchaseScriptResponse executePrePurchaseScript(ECPlayer player, Shop shop) {
        if (shop.getPrePurchaseScript().isBlank()) {
            return PrePurchaseScriptResponse.getBlank();
        }
        try {
            GroovyScriptResponse response = ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(shop.getPrePurchaseScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).withVariable(GROOVY_ALLOW_PURCHASE, true)).withVariable(GROOVY_FAIL_MESSAGE, null)).withVariable(GROOVY_DISCOUNT_PERCENTAGE, 0.0)).execute();
            boolean allowPurchase = response.getBooleanVariable(GROOVY_ALLOW_PURCHASE);
            String failMessage = response.getStringVariable(GROOVY_FAIL_MESSAGE);
            Double discountPercentage = response.getDoubleVariable(GROOVY_DISCOUNT_PERCENTAGE);
            discountPercentage = discountPercentage != null ? discountPercentage : 0.0;
            return new PrePurchaseScriptResponse(allowPurchase, failMessage, discountPercentage);
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing pre purchase script for shop %s", shop.getName()), ex);
            return new PrePurchaseScriptResponse(false, null, 0.0);
        }
    }

    private record PrePurchaseScriptResponse(boolean allowPurchase, String failMessage, double discountPercentage) {
        private static final PrePurchaseScriptResponse BLANK = new PrePurchaseScriptResponse(true, null, 0.0);

        public static PrePurchaseScriptResponse getBlank() {
            return BLANK;
        }
    }
}

