/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop.item;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.shop.item.ShopItem;
import java.util.List;

public class ShopItemDatabase
implements RepositoryDatasource<ShopItem, Integer> {
    @Override
    public List<ShopItem> retrieveAll() {
        return Query.selectAllFrom("SHOP_ITEM").getList(this::getFromResultRow);
    }

    private ShopItem getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        int shopId = row.getInt("SHOP_ID");
        int itemId = row.getInt("ITEM_ID");
        double price = row.getDouble("PRICE");
        Integer playerLimit = row.getNullableInt("PLAYER_LIMIT");
        Integer playerLimitHoursDuration = row.getNullableInt("PLAYER_LIMIT_HOURS_DURATION");
        Integer globalLimit = row.getNullableInt("GLOBAL_LIMIT");
        Integer globalLimitHoursDuration = row.getNullableInt("GLOBAL_LIMIT_HOURS_DURATION");
        return new ShopItem(id, shopId, itemId, price, playerLimit, playerLimitHoursDuration, globalLimit, globalLimitHoursDuration);
    }
}

