/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.shop.log.ShopItemLog;
import java.util.List;

public class ShopItemLogDatabase
implements RepositoryDatasource<ShopItemLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_SHOP_ITEM_ID = "SHOP_ITEM_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_PRICE_PER_ITEM = "PRICE_PER_ITEM";
    private static final String COLUMN_QUANTITY = "QUANTITY";

    @Override
    public void create(ShopItemLog shopItemLog) {
        Query.insertInto("SHOP_ITEM_LOG").columns(QueryColumn.column(COLUMN_SHOP_ITEM_ID, shopItemLog.getShopItemId()), QueryColumn.column(COLUMN_PLAYER_ID, shopItemLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, shopItemLog.getTimeStamp()), QueryColumn.column(COLUMN_PRICE_PER_ITEM, shopItemLog.getPricePerItem()), QueryColumn.column(COLUMN_QUANTITY, shopItemLog.getQuantity())).executeGetGeneratedKey(shopItemLog::setId);
    }

    @Override
    public List<ShopItemLog> retrieveAll() {
        return Query.selectAllFrom("SHOP_ITEM_LOG").getList(this::getFromResultRow);
    }

    private ShopItemLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int shopItemId = row.getInt(COLUMN_SHOP_ITEM_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        double pricePerItem = row.getDouble(COLUMN_PRICE_PER_ITEM);
        int quantity = row.getInt(COLUMN_QUANTITY);
        return new ShopItemLog(id, shopItemId, playerId, timeStamp, pricePerItem, quantity);
    }
}

