/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.shop.log.ShopItemLog;
import com.equestricraft.core.shop.log.ShopItemLogDatabase;
import java.util.Date;
import java.util.List;

public class ShopItemLogRepository
extends Repository<ShopItemLog, Integer> {
    @Service
    private ShopItemLogDatabase shopItemLogDatabase;

    @Override
    protected RepositoryDatasource<ShopItemLog, Integer> getDatasource() {
        return this.shopItemLogDatabase;
    }

    public List<ShopItemLog> findLogsByShopItemId(int shopItemId, Date sinceDate) {
        RepositorySearchQuery<ShopItemLog> searchQuery = this.createSearchQuery();
        searchQuery.mappedEquals(ShopItemLog::getShopItemId, shopItemId);
        searchQuery.filter(l -> l.getTimeStamp() >= sinceDate.getTime());
        return searchQuery.many();
    }

    public List<ShopItemLog> findLogsByShopItemAndPlayer(int shopItemId, int playerId, Date sinceDate) {
        RepositorySearchQuery<ShopItemLog> searchQuery = this.createSearchQuery();
        searchQuery.mappedEquals(ShopItemLog::getShopItemId, shopItemId);
        searchQuery.mappedEquals(ShopItemLog::getPlayerId, playerId);
        searchQuery.filter(l -> l.getTimeStamp() >= sinceDate.getTime());
        return searchQuery.many();
    }
}

