/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.shop.log;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.shop.item.ShopItem;
import com.equestricraft.core.shop.log.ShopItemLog;
import com.equestricraft.core.shop.log.ShopItemLogRepository;
import com.equestricraft.core.shop.log.ShopItemLogSession;
import java.time.Duration;
import java.util.Date;
import java.util.List;

public class ShopItemLogSessionImpl
implements ShopItemLogSession {
    @Service
    private ShopItemLogRepository shopItemLogRepository;

    @Override
    public void logShopItemPurchase(ECPlayer player, ShopItem shopItem, int quantity) {
        ShopItemLog logEntry = new ShopItemLog(0, shopItem.getId(), player.getId(), System.currentTimeMillis(), shopItem.getPrice(), quantity);
        this.shopItemLogRepository.add(logEntry);
    }

    @Override
    public int getQuantitySoldOfItemInPastDuration(int shopItemId, Duration duration) {
        Date baseDate = DateUtils.futureMillisOffset(-duration.toMillis());
        List<ShopItemLog> logs = this.shopItemLogRepository.findLogsByShopItemId(shopItemId, baseDate);
        return this.countQuantityAcrossLogs(logs);
    }

    @Override
    public int getQuantityOfItemSoldToPlayerInPastDuration(int shopItemId, ECPlayer player, Duration duration) {
        Date baseDate = DateUtils.futureMillisOffset(-duration.toMillis());
        return this.getQuantityOfItemSoldToPlayerSinceTime(shopItemId, player, baseDate);
    }

    @Override
    public int getQuantityOfItemSoldToPlayerSinceTime(int shopItemId, ECPlayer player, Date time) {
        List<ShopItemLog> logs = this.shopItemLogRepository.findLogsByShopItemAndPlayer(shopItemId, player.getId(), time);
        return this.countQuantityAcrossLogs(logs);
    }

    private int countQuantityAcrossLogs(List<ShopItemLog> logs) {
        return logs.stream().mapToInt(ShopItemLog::getQuantity).sum();
    }
}

