/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.skill;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.core.skill.SkillConfig;
import java.util.List;

public class SkillConfigDatabase
implements RepositoryDatasource<SkillConfig, Integer> {
    @Override
    public List<SkillConfig> retrieveAll() {
        return Query.selectAllFrom("SKILL").getList(this::getFromResultRow);
    }

    private SkillConfig getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        Skill identifier = row.getEnum("IDENTIFIER", Skill.class);
        String description = row.getString("DESCRIPTION");
        int horseXpThreshold = row.getInt("HORSE_XP_THRESHOLD");
        int playerXpThreshold = row.getInt("PLAYER_XP_THRESHOLD");
        return new SkillConfig(id, name, identifier, description, horseXpThreshold, playerXpThreshold);
    }
}

