/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.spawn;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.spawn.SpawnPoint;
import com.equestricraft.core.spawn.SpawnPointDatabase;
import com.equestricraft.core.spawn.SpawnPointHolder;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoader;
import com.equestricraft.logging.Log;
import java.util.Optional;

public class SpawnPointLoadService
implements DataLoader {
    @Service
    private SpawnPointDatabase spawnPointDatabase;
    private final SpawnPointHolder spawnPointHolder = SpawnPointHolder.getInstance();
    private static final Log log = Log.getLogger(SpawnPointLoadService.class.getName());

    @Override
    public void loadData() {
        Optional<SpawnPoint> spawnPoint = this.spawnPointDatabase.retrieveSpawnPoint();
        if (spawnPoint.isPresent()) {
            this.spawnPointHolder.setSpawnPoint(spawnPoint.get());
        } else {
            log.warn("No spawn point has been defined, the world default will be used instead");
            this.spawnPointHolder.setSpawnPoint(null);
        }
    }

    @Override
    public DataLoadModule module() {
        return DataLoadModule.SPAWN_POINTS;
    }
}

